package cc.cassian.raspberry.mixin.cofh_core;

import cofh.core.init.CoreMobEffects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(Snowball.class)
public class SnowballMixin {
    @Inject(method = "onHitEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private void mixin(EntityHitResult result, CallbackInfo ci) {
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity livingEntity) {
            if (livingEntity.m_5801_()) {
                livingEntity.m_7292_(new MobEffectInstance(CoreMobEffects.CHILLED.get(), 60));
            }
        }
    }
}
