package cc.cassian.raspberry.mixin.create;

import cc.cassian.raspberry.client.ClientHelpers;
import cc.cassian.raspberry.config.ModConfig;
import com.simibubi.create.AllItems;
import net.mehvahdjukaar.supplementaries.common.items.WrenchItem;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(WrenchItem.class)
public abstract class WrenchItemMixin {

    @Inject(method = "useOn", at = @At(value = "HEAD"), cancellable = true)
    public void use(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        if (ModConfig.get().unified_wrenches) {
            InteractionResult interactionResult = AllItems.WRENCH.get().m_6225_(context);
            var player = context.m_43723_();
            if (interactionResult == InteractionResult.SUCCESS) {
                if (player instanceof ServerPlayer serverPlayer) {
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, context.m_8083_(), context.m_43722_());
                    context.m_43725_().m_142346_(player, GameEvent.f_157792_, context.m_8083_());
                } else {
                    if (!ClientHelpers.isShiftDown())
                        raspberryCore$playTurningParticles(context.m_8083_(), false, context.m_8125_(), context.m_43725_(), player);
                }
                if (player != null)
                    context.m_43722_().m_41622_(1, player, (p) -> p.m_21190_(context.m_43724_()));
                cir.setReturnValue(InteractionResult.SUCCESS);
            }
        }
    }

    @Unique
    private static void raspberryCore$playTurningParticles(BlockPos pos, boolean shiftDown, Direction dir, Level level, Player player) {
        if (net.mehvahdjukaar.supplementaries.configs.ClientConfigs.Items.WRENCH_PARTICLES.get()) {
            if (dir == Direction.DOWN) {
                shiftDown = !shiftDown;
            }

            level.m_7106_(ModParticles.ROTATION_TRAIL_EMITTER.get(), (double)pos.m_123341_() + (double)0.5F, (double)pos.m_123342_() + (double)0.5F, (double)pos.m_123343_() + (double)0.5F, dir.m_122411_(), 0.71, shiftDown ? (double)1.0F : (double)-1.0F);
        }
    }
}
