package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.config.ModConfig;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(Raider.class)
public abstract class RaiderMixin extends PatrollingMonster {
    protected RaiderMixin(EntityType<? extends PatrollingMonster> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method = "aiStep", at = @At(value = "HEAD"))
    public void burnInDaylight(CallbackInfo ci) {
        var e = (Raider) (Object) this;
        if (this.m_6084_() && !(e instanceof Witch)) {
            boolean flag = ModConfig.get().sunSensitiveRaiders && this.m_21527_();
            if (flag) {
                ItemStack itemstack = this.m_6844_(EquipmentSlot.HEAD);
                if (!itemstack.m_41619_()) {
                    if (itemstack.m_41763_()) {
                        itemstack.m_41721_(itemstack.m_41773_() + this.f_19796_.m_188503_(2));
                        if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                            this.m_21166_(EquipmentSlot.HEAD);
                            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                        }
                    }

                    flag = false;
                }

                if (flag) {
                    this.m_20254_(8);
                }
            }
        }
    }
}
