package cc.cassian.raspberry.mixin.naturalist;

import cc.cassian.raspberry.registry.RaspberryItems;
import com.starfish_studios.naturalist.Naturalist;
import com.starfish_studios.naturalist.common.entity.Firefly;
import com.starfish_studios.naturalist.common.helper.ItemHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistRecipes;
import com.starfish_studios.naturalist.core.registry.NaturalistRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(Animal.class)
public class CatchableFireflyMixin {

    @Inject(method = "mobInteract", at = @At(value = "HEAD"), cancellable = true)
    private void stackableButterflies(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        var entity = (Animal) (Object) this;
        if (entity instanceof Firefly) {
            ItemStack itemStack = player.m_21120_(hand);

            if (itemStack.m_41720_().equals(NaturalistRegistry.BUG_NET.get()) && entity.m_6084_()) {
                ItemStack caughtItemStack = RaspberryItems.FIREFLY.get().m_7968_();
                itemStack.m_41622_(1, player, (playerEntity) -> playerEntity.m_21190_(hand));

                if (player.m_150109_().m_36054_(caughtItemStack)) {
                    entity.m_146870_();
                    cir.setReturnValue(InteractionResult.SUCCESS);
                } else {
                    ItemHelper.spawnItemOnEntity(player, caughtItemStack);
                    player.m_5496_(SoundEvents.f_12019_, 0.3F, 1.0F);
                    if (!entity.m_9236_().m_5776_()) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, caughtItemStack);
                    }

                    entity.m_146870_();
                    cir.setReturnValue(InteractionResult.SUCCESS);
                }
            }
        }

    }

}
