package cc.cassian.raspberry.blocks;

import cc.cassian.raspberry.compat.BuzzierBeesCompat;
import cc.cassian.raspberry.compat.CavernsAndChasmsCompat;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.*;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

import java.util.function.Supplier;

public class RaspberryCakeBlock extends Block {
    public static final IntegerProperty BITES;
    public static final IntegerProperty CANDLE_TYPE;
    public static final BooleanProperty LIT;
    protected static final VoxelShape[] SHAPE_BY_BITE;
    public final String cakeSliceItemID;
    private static final Iterable<Vec3> PARTICLE_OFFSETS;

    public RaspberryCakeBlock(Properties properties, String cakeSlice) {
        super(properties);
        this.cakeSliceItemID = cakeSlice;
        this.m_49959_(this.f_49792_.m_61090_().m_61124_(BITES, 0).m_61124_(CANDLE_TYPE, 0).m_61124_(LIT, false));
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_61143_(LIT) ? 3 : 0;
    }


    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return PARTICLE_OFFSETS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.m_61143_(LIT)) {
            this.getParticleOffsets(state).forEach((arg4) -> addParticlesAndSound(state, level, arg4.m_82520_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), random));
        }
    }

    private static void addParticlesAndSound(BlockState state, Level level, Vec3 offset, RandomSource random) {
        int candleType = state.m_61143_(CANDLE_TYPE);
        float f = random.m_188501_();
        if (f < 0.3F) {
            level.m_7106_(ParticleTypes.f_123762_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0F, 0.0F, 0.0F);
            if (f < 0.17F) {
                level.m_7785_(offset.f_82479_ + (double)0.5F, offset.f_82480_ + (double)0.5F, offset.f_82481_ + (double)0.5F, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0F + random.m_188501_(), random.m_188501_() * 0.7F + 0.3F, false);
            }
        }
        if (candleType == 18) {
            level.m_7106_(ParticleTypes.f_123745_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0F, 0.0F, 0.0F);
        }
        else if (candleType == 19) {
            level.m_7106_(CavernsAndChasmsCompat.getCupricCandleFlame(), offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0F, 0.0F, 0.0F);
        }
        else {
            level.m_7106_(ParticleTypes.f_175834_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0F, 0.0F, 0.0F);
        }
    }

    public ItemStack getCakeSliceItem() {
       return ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.cakeSliceItemID)).m_7968_();
    }

    public int getMaxBites() {
        return 7;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_BITE[state.m_61143_(BITES)];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (heldStack.m_204117_(ModTags.KNIVES)) {
                return this.cutSlice(level, pos, state, player);
            }

            if (heldStack.m_204117_(ItemTags.f_144319_)) {
                return this.placeCandle(level, pos, state, player, heldStack);
            }

            if (heldStack.m_150930_(Items.f_42409_) || heldStack.m_150930_(Items.f_42613_)) {
                return this.lightCandle(level, pos, state, player, heldStack);
            }

            if (this.consumeBite(level, pos, state, player) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }

            if (heldStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }

        return (heldStack.m_204117_(ModTags.KNIVES) ? this.cutSlice(level, pos, state, player) :
                (heldStack.m_204117_(ItemTags.f_144319_) ? this.placeCandle(level, pos, state, player, heldStack) :
                (heldStack.m_150930_(Items.f_42409_) || heldStack.m_150930_(Items.f_42613_) ? this.lightCandle(level, pos, state, player, heldStack) :
                        this.consumeBite(level, pos, state, player))));
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int candleType = state.m_61143_(CANDLE_TYPE);
        if (candleType > 0) {
            popCandle(level, pos, state, candleType, true);
            return InteractionResult.SUCCESS;
        }
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        } else {
            ItemStack sliceStack = this.getCakeSliceItem();
            FoodProperties sliceFood = sliceStack.m_41720_().m_41473_();
            playerIn.m_36324_().m_38712_(sliceStack.m_41720_(), sliceStack);
            if (this.getCakeSliceItem().m_41720_().m_41472_() && sliceFood != null) {
                for(Pair<MobEffectInstance, Float> pair : sliceFood.m_38749_()) {
                    if (!level.f_46443_ && pair.getFirst() != null && level.f_46441_.m_188501_() < pair.getSecond()) {
                        playerIn.m_7292_(new MobEffectInstance(pair.getFirst()));
                    }
                }
            }

            int bites = state.m_61143_(BITES);
            if (bites < this.getMaxBites() - 1) {
                level.m_7731_(pos, state.m_61124_(BITES, bites + 1), 3);
            } else {
                level.m_7471_(pos, false);
            }

            playerIn.m_36220_(Stats.f_12942_);
            level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8F, 0.8F);
            return InteractionResult.SUCCESS;
        }
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = state.m_61143_(BITES);
        int candleType = state.m_61143_(CANDLE_TYPE);
        if (candleType > 0) {
            popCandle(level, pos, state, candleType, true);
            return InteractionResult.SUCCESS;
        }
        if (bites < this.getMaxBites() - 1) {
            level.m_7731_(pos, state.m_61124_(BITES, bites + 1), 3);
        } else {
            level.m_7471_(pos, false);
        }

        Direction direction = player.m_6350_().m_122424_();
        ItemUtils.spawnItemEntity(level, this.getCakeSliceItem(), (double)pos.m_123341_() + (double)0.5F, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + (double)0.5F, (double)direction.m_122429_() * 0.15, 0.05, (double)direction.m_122431_() * 0.15);
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8F, 0.8F);
        return InteractionResult.SUCCESS;
    }

    public void useItem(Player player, ItemStack itemStack) {
        if (!player.m_7500_()) {
            if (itemStack.m_41763_()) {
                itemStack.m_41721_(itemStack.m_41773_() + 1);

                if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                    itemStack.m_41774_(1);
                }
            } else {
                itemStack.m_41774_(1);
            }
        }

    }

    protected InteractionResult placeCandle(Level level, BlockPos pos, BlockState state, Player player, ItemStack heldStack) {
        int bites = state.m_61143_(BITES);
        int candleType = state.m_61143_(CANDLE_TYPE);
        if (bites == 0 && candleType == 0) {
            level.m_7731_(pos, state.m_61124_(CANDLE_TYPE, getCandleNum(heldStack)), 3);
            useItem(player, heldStack);
        } else if (candleType > 0) {
            popCandle(level, pos, state, candleType, true);
        }
        else {
            return InteractionResult.PASS;
        }

        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8F, 0.8F);
        return InteractionResult.SUCCESS;
    }

    public void popCandle(Level level, BlockPos pos, BlockState state, int candleType, Boolean shouldSet) {
        if (state.m_61143_(LIT) && shouldSet) {
            level.m_7731_(pos, state.m_61124_(LIT, false), 3);
            level.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0F, 1.0F);
        } else {
            if (shouldSet){
            level.m_7731_(pos, state.m_61124_(CANDLE_TYPE, 0), 3);
                level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8F, 0.8F);
            }

            ItemUtils.spawnItemEntity(level, this.getCandleItem(candleType), pos.m_123341_() + 0.5, pos.m_123342_() + 0.3, pos.m_123343_() + 0.5, 0.0, 0.05, 0.0);
        }
    }


    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            int candleType = state.m_61143_(CANDLE_TYPE);
            if (candleType > 0) {
                popCandle(level, pos, state, candleType, false);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }


    protected InteractionResult lightCandle(Level level, BlockPos pos, BlockState state, Player player, ItemStack heldStack) {
        int candleType = state.m_61143_(CANDLE_TYPE);
        Boolean lit = state.m_61143_(LIT);
        if (candleType > 0 && !lit) {
            level.m_7731_(pos, state.m_61124_(LIT, true), 3);
            useItem(player, heldStack);

            level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0F, 1.0F);
            return InteractionResult.SUCCESS;
        }
        else {
            return InteractionResult.PASS;
        }
    }

    @Override
    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.f_46443_ && projectile.m_6060_()) {
            int candleType = state.m_61143_(CANDLE_TYPE);
            Boolean lit = state.m_61143_(LIT);
            if (candleType > 0 && !lit) {
                level.m_7731_(hit.m_82425_(), state.m_61124_(LIT, true), 3);

                level.m_5594_(null, hit.m_82425_(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0F, 1.0F);
            }
        }
    }

    public ItemStack getCandleItem(int candleType) {
        if (candleType == 1) {
            return new ItemStack(Items.f_151065_);
        }
        else if (candleType == 2) {
            return new ItemStack(Items.f_151066_);
        }
        else if (candleType == 3) {
            return new ItemStack(Items.f_151074_);
        }
        else if (candleType == 4) {
            return new ItemStack(Items.f_151073_);
        }
        else if (candleType == 5) {
            return new ItemStack(Items.f_151082_);
        }
        else if (candleType == 6) {
            return new ItemStack(Items.f_151078_);
        }
        else if (candleType == 7) {
            return new ItemStack(Items.f_151081_);
        }
        else if (candleType == 8) {
            return new ItemStack(Items.f_151067_);
        }
        else if (candleType == 9) {
            return new ItemStack(Items.f_151070_);
        }
        else if (candleType == 10) {
            return new ItemStack(Items.f_151071_);
        }
        else if (candleType == 11) {
            return new ItemStack(Items.f_151080_);
        }
        else if (candleType == 12) {
            return new ItemStack(Items.f_151075_);
        }
        else if (candleType == 13) {
            return new ItemStack(Items.f_151069_);
        }
        else if (candleType == 14) {
            return new ItemStack(Items.f_151077_);
        }
        else if (candleType == 15) {
            return new ItemStack(Items.f_151076_);
        }
        else if (candleType == 16) {
            return new ItemStack(Items.f_151068_);
        }
        else if (candleType == 17) {
            return new ItemStack(Items.f_151072_);
        }
        else if (candleType == 18) {
            return new ItemStack(BuzzierBeesCompat.getSoulCandle());
        }
        else if (candleType == 19) {
            return new ItemStack(CavernsAndChasmsCompat.getCupricCandle());
        }
        else {
            return new ItemStack(Items.f_151065_);
        }
    }

    public int getCandleNum(ItemStack heldStack) {
        if (heldStack.m_150930_(Items.f_151065_)) {
            return 1;
        }
        else if (heldStack.m_150930_(Items.f_151066_)) {
            return 2;
        }
        else if (heldStack.m_150930_(Items.f_151074_)) {
            return 3;
        }
        else if (heldStack.m_150930_(Items.f_151073_)) {
            return 4;
        }
        else if (heldStack.m_150930_(Items.f_151082_)) {
            return 5;
        }
        else if (heldStack.m_150930_(Items.f_151078_)) {
            return 6;
        }
        else if (heldStack.m_150930_(Items.f_151081_)) {
            return 7;
        }
        else if (heldStack.m_150930_(Items.f_151067_)) {
            return 8;
        }
        else if (heldStack.m_150930_(Items.f_151070_)) {
            return 9;
        }
        else if (heldStack.m_150930_(Items.f_151071_)) {
            return 10;
        }
        else if (heldStack.m_150930_(Items.f_151080_)) {
            return 11;
        }
        else if (heldStack.m_150930_(Items.f_151075_)) {
            return 12;
        }
        else if (heldStack.m_150930_(Items.f_151069_)) {
            return 13;
        }
        else if (heldStack.m_150930_(Items.f_151077_)) {
            return 14;
        }
        else if (heldStack.m_150930_(Items.f_151076_)) {
            return 15;
        }
        else if (heldStack.m_150930_(Items.f_151068_)) {
            return 16;
        }
        else if (heldStack.m_150930_(Items.f_151072_)) {
            return 17;
        }
        else if (heldStack.m_150930_(BuzzierBeesCompat.getSoulCandle().m_5456_())) {
            return 18;
        }
        else if (heldStack.m_150930_(CavernsAndChasmsCompat.getCupricCandle().m_5456_())) {
            return 19;
        }
        else {
            return 0;
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_(level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(BITES, CANDLE_TYPE, LIT);
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - blockState.m_61143_(BITES);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        BITES = IntegerProperty.m_61631_("bites", 0, 6);
        CANDLE_TYPE = IntegerProperty.m_61631_("candle_type", 0, 19);
        LIT = AbstractCandleBlock.f_151895_;
        SHAPE_BY_BITE = new VoxelShape[]{Block.m_49796_(1.0F, 0.0F, 1.0F, 15.0F, 8.0F, 15.0F), Block.m_49796_(3.0F, 0.0F, 1.0F, 15.0F, 8.0F, 15.0F), Block.m_49796_(5.0F, 0.0F, 1.0F, 15.0F, 8.0F, 15.0F), Block.m_49796_(7.0F, 0.0F, 1.0F, 15.0F, 8.0F, 15.0F), Block.m_49796_(9.0F, 0.0F, 1.0F, 15.0F, 8.0F, 15.0F), Block.m_49796_(11.0F, 0.0F, 1.0F, 15.0F, 8.0F, 15.0F), Block.m_49796_(13.0F, 0.0F, 1.0F, 15.0F, 8.0F, 15.0F)};
        PARTICLE_OFFSETS = ImmutableList.of(new Vec3(0.5F, 1.0F, 0.5F));
    }
}
