package cc.cassian.raspberry.client.toast;

import cc.cassian.raspberry.client.music.MusicHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class MusicToast implements Toast {
    private final MusicHandler.MusicMetadata music;
    private final ItemStack iconItem;
    private final ResourceLocation iconTexture;

    public MusicToast(MusicHandler.MusicMetadata music, ItemStack icon) {
        this.music = music;
        this.iconItem = icon;
        this.iconTexture = null;
    }

    public MusicToast(MusicHandler.MusicMetadata music, ResourceLocation icon) {
        this.music = music;
        this.iconItem = null;
        this.iconTexture = icon;
    }

    @Override
    public Visibility m_7172_(PoseStack poseStack, ToastComponent toastComponent, long timeSinceLastVisible) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_(0, f_94893_);
        RenderSystem.m_157429_(1.0F, 1.0F, 1.0F, 1.0F);

        toastComponent.m_93228_(poseStack, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());

        if (iconTexture != null) {
            int iconSize = 20;
            int iconX = 8;
            int iconY = 6;

            RenderSystem.m_157456_(0, iconTexture);
            GuiComponent.m_93133_(poseStack, iconX, iconY, 0, 0, iconSize, iconSize, iconSize, iconSize);
        } else if (iconItem != null) {
            toastComponent.m_94929_().m_91291_().m_115203_(iconItem, 8, 8);
        }

        int textLeft = 30;
        boolean hasAuthor = !music.author().getString().isEmpty();

        if (hasAuthor) {
            toastComponent.m_94929_().f_91062_.m_92889_(poseStack, music.title(), textLeft, 7, 0xFFFFFF00);
            toastComponent.m_94929_().f_91062_.m_92889_(poseStack, music.author(), textLeft, 18, 0xFFFFFFFF);
        } else {
            toastComponent.m_94929_().f_91062_.m_92889_(poseStack, music.title(), textLeft, 12, 0xFFFFFF00);
        }

        return timeSinceLastVisible >= 5000L ? Visibility.HIDE : Visibility.SHOW;
    }
}