package cc.cassian.raspberry.compat;

import cc.cassian.raspberry.compat.emi.EmiFermentingRecipe;
import cc.cassian.raspberry.mixin.brewinandchewin.KegRecipeMixin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.resources.ResourceLocation;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.crafting.KegRecipe;
import umpaz.brewinandchewin.common.registry.BCItems;
import umpaz.brewinandchewin.common.registry.BCRecipeTypes;

public class BrewinAndChewinCompat {
    public static final EmiRecipeCategory FERMENTING = new EmiRecipeCategory(new ResourceLocation(BrewinAndChewin.MODID, "fermenting"), EmiStack.of(BCItems.KEG.get()));

    public static void registerEmi(EmiRegistry emiRegistry) {
        for (KegRecipe recipe : emiRegistry.getRecipeManager().m_44013_(BCRecipeTypes.FERMENTING.get())) {
            emiRegistry.addRecipe(new EmiFermentingRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.getRecipeBookTab(), ((KegRecipeMixin) recipe).getInputItems(), recipe.getFluidItem(), recipe.m_8043_(), recipe.getOutputContainer(), recipe.getExperience(), recipe.getFermentTime(), recipe.getTemperature()));
        }
        emiRegistry.addCategory(FERMENTING);
        emiRegistry.addWorkstation(FERMENTING, EmiStack.of(BCItems.KEG.get()));
    }
}
