package cc.cassian.raspberry.compat;

import cc.cassian.raspberry.RaspberryData;
import cc.cassian.raspberry.entity.ai.goal.HuntWormGoal;
import cc.cassian.raspberry.registry.RaspberryBlocks;
import cc.cassian.raspberry.registry.RaspberryTags;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.environmental.core.other.EnvironmentalProperties;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

import java.util.Set;

public class EnvironmentalCompat {

    public static BlockBehaviour.Properties getTruffleProperties() {
        return EnvironmentalProperties.BURIED_TRUFFLE;
    }

    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Level level = event.getLevel();
        RandomSource random = level.m_213780_();

        if (target.m_6095_().m_204039_(RaspberryTags.WORM_SEEKERS) && target.m_6084_() && target instanceof Animal seeker) {
            IDataManager data = ((IDataManager) target);
            if (!seeker.m_21523_() && stack.m_204117_(RaspberryTags.WORM_SEEKER_ITEMS) && !seeker.m_6162_()) {
                if (data.getValue(RaspberryData.WORM_HUNTING_TIME) == 0) {
                    if (level.m_6042_().f_63858_()) {
                        data.setValue(RaspberryData.WORM_HUNTING_TIME, 4800);
                        if (!event.getEntity().m_7500_()) stack.m_41774_(1);

                        if (level.m_5776_()) {
                            for (int i = 0; i < 7; ++i) {
                                double d0 = random.m_188583_() * 0.02D;
                                double d1 = random.m_188583_() * 0.02D;
                                double d2 = random.m_188583_() * 0.02D;
                                // TODO: replace particles because these look piggy ofc
                                level.m_7106_(EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), target.m_20208_(1.0D), target.m_20187_() + 0.5D, target.m_20262_(1.0D), d0, d1, d2);
                            }
                        }
                    } else if (level.m_5776_()) {
                        for (int i = 0; i < 7; ++i) {
                            double d0 = random.m_188583_() * 0.02D;
                            double d1 = random.m_188583_() * 0.02D;
                            double d2 = random.m_188583_() * 0.02D;
                            level.m_7106_(ParticleTypes.f_123762_, target.m_20208_(1.0D), target.m_20187_() + 0.5D, target.m_20262_(1.0D), d0, d1, d2);
                        }
                    }

                    event.setCancellationResult(InteractionResult.m_19078_(level.m_5776_()));
                    event.setCanceled(true);
                }
            }
        }
    }

    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_6095_().m_204039_(RaspberryTags.WORM_SEEKERS) && entity instanceof Animal seeker) {
            Set<WrappedGoal> goals = seeker.f_21345_.m_148105_();
            if (goals.stream().noneMatch((goal) -> goal.m_26015_() instanceof HuntWormGoal))
                seeker.f_21345_.m_25352_(2, new HuntWormGoal(seeker));
        }
    }

    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.m_20193_();
        RandomSource random = level.m_213780_();

        if (entity.m_6095_().m_204039_(RaspberryTags.WORM_SEEKERS) && entity.m_6084_()) {
            IDataManager data = ((IDataManager) entity);
            int huntingtime = data.getValue(RaspberryData.WORM_HUNTING_TIME);
            BlockPos wormpos = data.getValue(RaspberryData.WORM_POS);

            if (huntingtime == 0 || (data.getValue(RaspberryData.HAS_WORM_TARGET) && level.m_8055_(wormpos).m_60734_() != RaspberryBlocks.WORMY_DIRT.getBlock())) {
                data.setValue(RaspberryData.HAS_WORM_TARGET, false);
                if (huntingtime > 0) data.setValue(RaspberryData.WORM_HUNTING_TIME, Math.max(-400, -huntingtime));
            } else {
                if (huntingtime > 0) {
                    data.setValue(RaspberryData.WORM_HUNTING_TIME, huntingtime - 1);
                } else {
                    data.setValue(RaspberryData.WORM_HUNTING_TIME, huntingtime + 1);
                    if (level.m_5776_() && data.getValue(RaspberryData.HAS_WORM_TARGET) && huntingtime % 10 == 0) {
                        double d0 = random.m_188583_() * 0.02D;
                        double d1 = random.m_188583_() * 0.02D;
                        double d2 = random.m_188583_() * 0.02D;
                        level.m_7106_(EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), entity.m_20208_(1.0D), entity.m_20187_() + 0.5D, entity.m_20262_(1.0D), d0, d1, d2);
                    }
                }
            }

            int sniffsoundtime = data.getValue(RaspberryData.SNIFF_SOUND_TIME);
            data.setValue(RaspberryData.SNIFF_SOUND_TIME, sniffsoundtime + 1);
            if (!level.m_5776_() && data.getValue(RaspberryData.LOOKING_FOR_WORM) && random.m_188503_(90) < sniffsoundtime) {
                ((Mob)entity).m_8032_();
                data.setValue(RaspberryData.SNIFF_SOUND_TIME, -90);
            }
        }
    }

}
