package cc.cassian.raspberry.entity;

import cc.cassian.raspberry.RaspberryMod;
import cc.cassian.raspberry.compat.supplementaries.RoseGoldBombExplosion;
import cc.cassian.raspberry.registry.RaspberryEntityTypes;
import cc.cassian.raspberry.registry.RaspberryItems;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.*;

public class RoseGoldBombEntity extends ImprovedProjectileEntity {

    private final boolean hasFuse = CommonConfigs.Tools.BOMB_FUSE.get() != 0;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;

    public RoseGoldBombEntity(EntityType<RoseGoldBombEntity> type, Level world) {
        super(type, world);
        this.maxAge = (hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200);
    }

    public RoseGoldBombEntity(Level worldIn, LivingEntity throwerIn) {
        super(RaspberryEntityTypes.ROSE_GOLD_BOMB.get(), throwerIn, worldIn);
        this.maxAge = (hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200);
    }

    public RoseGoldBombEntity(Level worldIn, double x, double y, double z) {
        super(RaspberryEntityTypes.ROSE_GOLD_BOMB.get(), x, y, z, worldIn);
        this.maxAge = (hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200);
    }

    //data to be saved when the entity gets unloaded
    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Active", this.active);
        compound.m_128405_("Timer", this.changeTimer);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.active = compound.m_128471_("Active");
        this.changeTimer = compound.m_128451_("Timer");
    }

    @Override
    public Packet<?> m_5654_() {
        return PlatformHelper.getEntitySpawnPacket(this);
    }

    @Override
    protected Item m_7881_() {
        return RaspberryItems.ROSE_GOLD_BOMB.get();
    }

    @Override
    public ItemStack m_7846_() {
        return RaspberryItems.ROSE_GOLD_BOMB.get().m_7968_();
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.f_19853_.m_7106_(new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack(ModRegistry.BOMB_ITEM.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0D, 0.0D, 0.0D);
        }
    }

    @Override
    public void m_7822_(byte id) {
        switch (id) {
            default -> super.m_7822_(id);
            case 3 -> {
                spawnBreakParticles();
                this.m_146870_();
            }
            case 10 -> {
                spawnBreakParticles();
                if (MiscUtils.FESTIVITY.isBirthday()) {
                    this.spawnParticleInASphere(ModParticles.CONFETTI_PARTICLE.get(), 55, 0.3f);
                } else {
                    f_19853_.m_7106_(ModParticles.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), this.m_20185_(), this.m_20186_() + 1, this.m_20189_(),
                            BombEntity.BombType.NORMAL.getRadius(), 0, 0);
                }
                this.spawnParticleInASphere(ParticleTypes.f_123797_, 100, 5f);

                this.m_146870_();
            }
            case 68 -> f_19853_.m_7106_(ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_() + 1, this.m_20189_(), 0, 0, 0);
            case 67 -> {
                RandomSource random = f_19853_.m_213780_();
                for (int i = 0; i < 10; ++i) {
                    f_19853_.m_7106_(ParticleTypes.f_123762_, this.m_20185_() + 0.25f - random.m_188501_() * 0.5f, this.m_20186_() + 0.45f - random.m_188501_() * 0.5f, this.m_20189_() + 0.25f - random.m_188501_() * 0.5f, 0, 0.005, 0);
                }
                this.active = false;
            }
        }
    }

    private void spawnParticleInASphere(ParticleOptions type, int amount, float speed) {
        double d = (Math.PI * 2) / amount;
        for (float d22 = 0; d22 < (Math.PI * 2D); d22 += d) {
            Vec3 v = new Vec3(speed, 0, 0);
            v = v.m_82524_(d22 + f_19796_.m_188501_() * 0.3f);
            v = v.m_82535_((float) ((f_19796_.m_188501_()) * Math.PI));
            this.f_19853_.m_7106_(type, this.m_20185_(), this.m_20186_() + 1, this.m_20189_(), v.f_82479_, v.f_82480_, v.f_82481_);
            //this.level.addParticle(ParticleTypes.SPIT, x, y, z, Math.cos(d22) * -10.0D, 0.0D, Math.sin(d22) * -10.0D);
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    @Override
    public void m_8119_() {

        //if((this.tickCount-1)%6==0) {
        //    this.playSound(ModSounds.GUNPOWDER_IGNITE.get(), 1.0f,
        //            1.8f + level.getRandom().nextFloat() * 0.2f);
        //}

        if (this.changeTimer > 0) {
            this.changeTimer--;
            f_19853_.m_7106_(ParticleTypes.f_123762_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 0.0D, 0.0D, 0.0D);
        }

        if (this.active && this.m_20069_()) {
            this.turnOff();
        }

        super.m_8119_();
    }

    @Override
    public void spawnTrailParticles(Vec3 currentPos, Vec3 newPos) {
        if (this.active && !this.f_19803_) {

            double x = currentPos.f_82479_;
            double y = currentPos.f_82480_;
            double z = currentPos.f_82481_;
            double dx = newPos.f_82479_ - x;
            double dy = newPos.f_82480_ - y;
            double dz = newPos.f_82481_ - z;
            int s = 4;
            for (int i = 0; i < s; ++i) {
                double j = i / (double) s;
                this.f_19853_.m_7106_(ModParticles.BOMB_SMOKE_PARTICLE.get(), x + dx * j, 0.5 + y + dy * j, z + dz * j, 0, 0.02, 0);
            }
        }
    }


    @Override
    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        hit.m_82443_().m_6469_(DamageSource.m_19361_(this, this.m_37282_()), 1);
        if (hit.m_82443_() instanceof LargeFireball) {
            this.superCharged = true;
            hit.m_82443_().m_142687_(RemovalReason.DISCARDED);
        }
    }

    public void turnOff() {
        if (!f_19853_.m_5776_()) {
            this.f_19853_.m_7605_(this, (byte) 67);
            f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5F, 1.5F);
        }
        this.active = false;
    }

    @Override
    public void m_6123_(Player entityIn) {
        if (!this.f_19853_.f_46443_) {
            if (!this.active && entityIn.m_150109_().m_36054_(this.m_7846_())) {
                entityIn.m_7938_(this, 1);
                this.m_142687_(RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        Vec3 vector3d = hit.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vector3d);
        Vec3 vector3d1 = vector3d.m_82541_().m_82490_(m_7139_());
        this.m_20343_(this.m_20185_() - vector3d1.f_82479_, this.m_20186_() - vector3d1.f_82480_, this.m_20189_() - vector3d1.f_82481_);
    }

    @Override
    protected float m_7139_() {
        return 0.05F;
    }

    @Override
    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_ && !this.hasFuse) {

            //normal explosion
            if (!this.m_213877_()) {
                this.reachedEndOfLife();
            }
        }
    }

    @Override
    protected void m_37283_() {
    }

    //createMiniExplosion
    @Override
    public void reachedEndOfLife() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12198_, SoundSource.NEUTRAL, 1.5F, 1.5f);

        if (!this.f_19853_.f_46443_) {
            if (this.active) {
                this.createExplosion();
                //spawn particles
                this.f_19853_.m_7605_(this, (byte) 10);
            } else {
                this.f_19853_.m_7605_(this, (byte) 3);
            }
            this.m_146870_();
        }

        //client one is discarded when the event is recieved otherwise sometimes particles dont spawn
    }

    private void createExplosion() {
        try {
            boolean breaks = this.m_37282_() instanceof Player ||
                    PlatformHelper.isMobGriefingOn(this.f_19853_, this.m_37282_());

            if (CompatHandler.FLAN && this.m_37282_() instanceof Player p && !FlanCompat.canBreak(p, new BlockPos(m_20182_()))) {
                breaks = false;
            }

            if (this.superCharged) {
                //second explosion when supercharged
                this.f_19853_.m_46518_(this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6f, breaks, breaks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
            }

            RoseGoldBombExplosion explosion = new RoseGoldBombExplosion(this.f_19853_, this,
                    new RoseGoldBombExplosion.RoseGoldBombExplosionDamageCalculator(),
                    this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), (float) 4f,
                    BombEntity.BombType.NORMAL, breaks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);

            explosion.m_46061_();
            explosion.doFinalizeExplosion();
        }catch (Exception e){
            this.m_146870_();
            RaspberryMod.LOGGER.error("Something went wrong while exploding a bomb:", e);
            throw e;
        }
    }
}