package cc.cassian.raspberry.entity.ai.goal;

import cc.cassian.raspberry.RaspberryData;
import cc.cassian.raspberry.config.ModConfig;
import cc.cassian.raspberry.registry.RaspberryBlocks;
import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

import java.util.EnumSet;
import java.util.List;

public class HuntWormGoal extends Goal {
    private final Animal seeker;
    private final IDataManager data;
    private int runDelay;
    private int lookTimer;
    private Vec3 lookVector;

    public HuntWormGoal(Animal seekerIn) {
        this.seeker = seekerIn;
        this.data = (IDataManager) this.seeker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean m_8036_() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        } else {
            this.runDelay = this.m_183277_(20);
            if (this.data.getValue(RaspberryData.HAS_WORM_TARGET)) {
                return true;
            } else {
                return this.data.getValue(RaspberryData.WORM_HUNTING_TIME) > 0 && this.findWorm();
            }
        }
    }

    @Override
    public boolean m_8045_() {
        return this.data.getValue(RaspberryData.HAS_WORM_TARGET) && this.data.getValue(RaspberryData.WORM_HUNTING_TIME) != 0;
    }

    @Override
    public void m_8056_() {
        this.lookVector = new Vec3(1.0D, 0.0D, 1.0D);
        this.moveToWorm();
        this.data.setValue(RaspberryData.LOOKING_FOR_WORM, true);
    }

    @Override
    public void m_8041_() {
        this.data.setValue(RaspberryData.LOOKING_FOR_WORM, false);
    }

    @Override
    public void m_8037_() {
        int wormhuntingtime = this.data.getValue(RaspberryData.WORM_HUNTING_TIME);
        BlockPos blockpos = this.data.getValue(RaspberryData.WORM_POS);
        Vec3 seekerpos = this.seeker.m_20182_();

        Vec3 vector3d = new Vec3((blockpos.m_123341_() + 0.5D) - seekerpos.m_7096_(), 0.0D, (blockpos.m_123343_() + 0.5D) - seekerpos.m_7094_()).m_82541_();

        this.seeker.m_21563_().m_24950_(seekerpos.m_7096_() + vector3d.m_7096_() * this.lookVector.m_7096_(), this.seeker.m_20186_() - 0.6D + this.lookVector.m_7098_(), seekerpos.m_7094_() + vector3d.m_7094_() * this.lookVector.m_7094_(), (float) (this.seeker.m_8085_() + 20), (float) this.seeker.m_8132_());

        if (blockpos.m_123314_(this.seeker.m_20183_(), 4.0D)) {
            if (wormhuntingtime > 0)
                this.data.setValue(RaspberryData.WORM_HUNTING_TIME, -800);
        } else {
            if (this.lookTimer-- <= 0) {
                this.lookTimer = this.m_183277_(18 + this.seeker.m_217043_().m_188503_(9));
                this.lookVector = new Vec3((double) this.seeker.m_217043_().m_188501_() * 1.2D, (double) this.seeker.m_217043_().m_188501_() * 0.4D, (double) this.seeker.m_217043_().m_188501_() * 1.2D);
            }

            this.moveToWorm();
        }
    }

    private void moveToWorm() {
        BlockPos blockpos = this.data.getValue(RaspberryData.WORM_POS);
        this.seeker.m_21573_().m_26519_((double) ((float) blockpos.m_123341_()) + 0.5D, blockpos.m_123342_() + 1, (double) ((float) blockpos.m_123343_()) + 0.5D, 1.1D);
    }

    private boolean findWorm() {
        if (!this.seeker.f_19853_.m_6042_().f_63858_())
            return false;

        int range = ModConfig.get().aquaculture_wormDiscoveryRange;
        int height = 16;
        BlockPos blockpos = this.seeker.m_20183_();
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();

        List<BlockPos> wormblocks = Lists.newArrayList();

        for (int i = 0; i < range; ++i) {
            boolean flag = false;

            for (int y = -height; y < height; ++y) {
                for (int x = 0; x <= i; x = x > 0 ? -x : 1 - x) {
                    for (int z = x < i && x > -i ? i : 0; z <= i; z = z > 0 ? -z : 1 - z) {
                        blockpos$mutable.m_122154_(blockpos, x, y - 1, z);

                        if (this.seeker.m_21444_(blockpos$mutable)) {
                            if (this.isWorm(this.seeker.f_19853_, blockpos$mutable)) {
                                this.data.setValue(RaspberryData.HAS_WORM_TARGET, true);
                                this.data.setValue(RaspberryData.WORM_POS, blockpos$mutable);
                                return true;
                            } else if (this.isSuitableForWorm(this.seeker.f_19853_, blockpos$mutable)) {
                                if (i <= 48 && !flag) {
                                    flag = true;
                                    wormblocks.clear();
                                }

                                wormblocks.add(blockpos$mutable.m_7949_());
                            }
                        }
                    }
                }
            }
        }

        if (wormblocks.size() > 0) {
            BlockPos wormpos = wormblocks.get(this.seeker.m_217043_().m_188503_(wormblocks.size()));

            this.seeker.f_19853_.m_7731_(wormpos, RaspberryBlocks.WORMY_DIRT.defaultBlockState(), 3);
            this.data.setValue(RaspberryData.HAS_WORM_TARGET, true);
            this.data.setValue(RaspberryData.WORM_POS, wormpos);

            return true;
        }

        return false;
    }

    private boolean isWorm(Level worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_60734_() == RaspberryBlocks.WORMY_DIRT.getBlock();
    }

    private boolean isSuitableForWorm(Level worldIn, BlockPos pos) {
        if (worldIn.m_8055_(pos).m_60734_() != Blocks.f_50493_)
            return false;

        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.m_8055_(pos.m_121945_(direction));

            if (direction == Direction.UP) {
                if (!blockstate.m_204336_(EnvironmentalBlockTags.GRASS_LIKE)) {
                    if (!blockstate.m_204336_(BlockTags.f_144274_) || !worldIn.m_8055_(pos.m_7494_()).m_204336_(EnvironmentalBlockTags.GRASS_LIKE)) {
                        return false;
                    }
                }
            } else if (!blockstate.m_204336_(BlockTags.f_144274_)) {
                return false;
            }
        }

        return true;
    }
}