package cc.cassian.raspberry.mixin.aquaculture;

import cc.cassian.raspberry.registry.RaspberryTags;
import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.item.HookItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import javax.annotation.Nonnull;

@Pseudo
@Mixin(targets = "com.teammetallurgy.aquaculture.item.AquaFishingRodItem$FishingRodEquipmentHandler")
public class FishingRodEquipmentHandlerMixin {
    @Shadow(remap = false) @Final @Mutable
    private ItemStackHandler items;

    @Inject(method = "<init>", at = @At("RETURN"))
    private void modifyItemHandler(@Nonnull ItemStack stack, CallbackInfo ci) {
        this.items = new ItemStackHandler(4) {
            public int getSlotLimit(int slot) {
                return slot == 1 ? 64 : 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return switch (slot) {
                    case 0 -> stack.m_41720_() instanceof HookItem;
                    case 1 -> stack.m_204117_(RaspberryTags.BAIT);
                    case 2 ->
                            stack.m_204117_(AquacultureAPI.Tags.FISHING_LINE) && stack.m_41720_() instanceof DyeableLeatherItem;
                    case 3 -> stack.m_204117_(AquacultureAPI.Tags.BOBBER) && stack.m_41720_() instanceof DyeableLeatherItem;
                    default -> false;
                };
            }

            protected void onContentsChanged(int slot) {
                CompoundTag tag = stack.m_41784_();
                tag.m_128365_("Inventory", this.serializeNBT());
                stack.m_41751_(tag);
            }
        };
    }
}

