package cc.cassian.raspberry.mixin.architects_palette;

import architectspalette.content.worldgen.features.TwistedTree;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.spongepowered.asm.mixin.Mixin;

import java.util.Optional;

@Mixin(TwistedTree.class)
public abstract class TwistedTreeMixin extends AbstractTreeGrower {

    /**
     * @author evanbones
     * @reason Load configured feature from registry instead of hardcoding it
     */
    @Override
    public boolean m_213817_(ServerLevel level, ChunkGenerator generator, BlockPos pos, BlockState state, RandomSource random) {
        
        ResourceLocation featureId = new ResourceLocation("architects_palette", "twisted_tree");
        ResourceKey<ConfiguredFeature<?, ?>> featureKey = ResourceKey.m_135785_(Registry.f_122881_, featureId);

        Optional<Holder<ConfiguredFeature<?, ?>>> featureHolder = level.m_5962_()
            .m_175515_(Registry.f_122881_)
            .m_203636_(featureKey);

        if (featureHolder.isEmpty()) {
            return false;
        }

        ConfiguredFeature<?, ?> configuredFeature = featureHolder.get().m_203334_();

        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 4);

        if (configuredFeature.m_224953_(level, generator, random, pos)) {
            return true;
        } else {
            level.m_7731_(pos, state, 4);
            return false;
        }
    }
}