package cc.cassian.raspberry.mixin.connectiblechains;

import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;

@Mixin(ChainKnotEntity.class)
public abstract class ChainKnotEntityBehaviorMixin extends HangingEntity {

    protected ChainKnotEntityBehaviorMixin(EntityType<? extends HangingEntity> p_31703_, Level p_31704_) {
        super(p_31703_, p_31704_);
    }

    @Shadow(remap = false) public abstract boolean canStayAttached();
    @Shadow(remap = false) public abstract void destroyLinks(boolean mayDrop);
    @Shadow(remap = false) public abstract void m_7084_();

    @Inject(method = "canStayAttached", at = @At("RETURN"), cancellable = true, remap = false)
    private void raspberry$checkForLeashKnot(CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValue() && !this.f_19853_.f_46443_) {
            BlockPos pos = this.m_20183_();
            AABB aabb = new AABB(pos).m_82400_(1.0); 
            List<LeashFenceKnotEntity> knots = this.f_19853_.m_45976_(LeashFenceKnotEntity.class, aabb);
            
            for (LeashFenceKnotEntity knot : knots) {
                if (knot.m_20183_().equals(pos) && knot.m_6084_()) {
                    cir.setReturnValue(false);
                    return;
                }
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void raspberry$tickCheckObstruction(CallbackInfo ci) {
        if (!this.f_19853_.f_46443_ && !this.canStayAttached()) {
            this.destroyLinks(true);
            this.m_146870_();
        }
    }

    @Inject(method = "interact", at = @At(value = "INVOKE", target = "Lcom/lilypuree/connectiblechains/entity/ChainKnotEntity;destroyLinks(Z)V", remap = false))
    private void raspberry$damageShearsOnInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(Tags.Items.SHEARS)) {
            stack.m_41622_(1, player, (p) -> p.m_21190_(hand));
        }
    }

    /**
     * @author evanbones
     * @reason Fixes inability to punch-break knots and adds durability usage to shears on punch.
     */
    @Overwrite
    public boolean m_7313_(Entity attacker) {
        if (attacker instanceof Player player) {
            if (!this.f_19853_.f_46443_) {
                this.m_7084_();
                this.destroyLinks(!player.m_7500_());
                this.m_146870_();

                ItemStack stack = player.m_21205_();
                if (stack.m_204117_(Tags.Items.SHEARS)) {
                    stack.m_41622_(1, player, (p) -> p.m_21190_(InteractionHand.MAIN_HAND));
                }
            }
            return true;
        }
        return false;
    }
}