package cc.cassian.raspberry.mixin.create;

import com.simibubi.create.content.kinetics.deployer.DeployerHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value = DeployerHandler.class, remap = false)
public class DeployerHandlerMixin {
    @Inject(method = "safeOnBeehiveUse(Lnet/minecraft/world/level/block/state/BlockState;" +
                        "Lnet/minecraft/world/level/Level;" +
                        "Lnet/minecraft/core/BlockPos;" +
                        "Lnet/minecraft/world/entity/player/Player;" +
                        "Lnet/minecraft/world/InteractionHand;" +
                        ")" + "Lnet/minecraft/world/InteractionResult;",
            at = @At(value = "HEAD"),
            cancellable = true)
    private static void safeOnBeehiveUseTaggedShears(BlockState state, Level world, BlockPos pos,
                                                                  Player player, InteractionHand hand,
                                                                  CallbackInfoReturnable<InteractionResult> cir) {
        /* Mixing into if statements is kinda iffy. https://github.com/SpongePowered/Mixin/issues/365#issuecomment-539464542
         * Replacing the call to getItem() to return something else also didn't work for some reason.
         * That's why we're just reimplementing the shears logic :)
         * The code is more or less just copied wholesale from the default impl.
         */

        BeehiveBlock block = (BeehiveBlock) state.m_60734_();
        ItemStack prevHeldItem = player.m_21120_(hand);
        int honeyLevel = state.m_61143_(BeehiveBlock.f_49564_);
        if (honeyLevel < 5) {
            cir.setReturnValue(InteractionResult.PASS);
            cir.cancel();
            return;
        }

        // Delegate to the default impl if it's not tagged as #forge:shears
        if (!prevHeldItem.m_204117_(Tags.Items.SHEARS)) return;

        world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11697_,
                SoundSource.NEUTRAL, 1.0F, 1.0F);
        player.m_150109_().m_150079_(new ItemStack(Items.f_42784_, 3));
        prevHeldItem.m_41622_(1, player, s -> s.m_21190_(hand));
        block.m_49590_(world, state, pos);

        cir.setReturnValue(InteractionResult.SUCCESS);
    }
}
