package cc.cassian.raspberry.mixin.etched;

import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

@Mixin(AlbumJukeboxBlockEntity.class)
public class AlbumJukeboxBlockEntityMixin {

    @Inject(method = "tick", at = @At("HEAD"), remap = false)
    private static void raspberry$tick(Level level, BlockPos pos, BlockState state, AlbumJukeboxBlockEntity entity, CallbackInfo ci) {
        if (level != null && !level.m_5776_() && entity.isPlaying()) {
            if (level.m_46467_() % 20 == 0) {
                int radius = GameEvent.f_238690_.m_157827_();
                AABB aabb = (new AABB(pos)).m_82400_(radius);
                List<Allay> list = level.m_45976_(Allay.class, aabb);
                for (Allay allay : list) {
                    if (!allay.m_239559_()) {
                        allay.m_240101_(pos, true);
                    }
                }
            }
        }
    }
}