package cc.cassian.raspberry.mixin.etched;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(Allay.class)
public abstract class AllayMixin extends PathfinderMob {

    @Shadow
    @Nullable
    private BlockPos jukeboxPos;

    protected AllayMixin(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method = "shouldStopDancing", at = @At("HEAD"), cancellable = true)
    private void raspberry$shouldStopDancing(CallbackInfoReturnable<Boolean> cir) {
        if (this.jukeboxPos != null) {
            ResourceLocation blockId = Registry.f_122824_.m_7981_(this.f_19853_.m_8055_(this.jukeboxPos).m_60734_());
            
            if (blockId.toString().equals("etched:album_jukebox")) {
                if (this.jukeboxPos.m_203195_(this.m_20182_(), GameEvent.f_238690_.m_157827_())) {
                    cir.setReturnValue(false); 
                }
            }
        }
    }
}