package cc.cassian.raspberry.mixin.farmersdelight;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.utility.MathUtils;

@Mixin(FlintAndSteelItem.class)
public class FlintAndSteelMixin {
    @Inject(
            method = "useOn",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/CampfireBlock;canLight(Lnet/minecraft/world/level/block/state/BlockState;)Z"),
            cancellable = true)
    private void lightStovesWithTwigs(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        var level = context.m_43725_();
        var state = level.m_8055_(context.m_8083_());
        if (state.m_60734_() instanceof StoveBlock && !state.m_61143_(BlockStateProperties.f_61443_)) {
            level.m_5594_(context.m_43723_(), context.m_8083_(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0F, MathUtils.RAND.nextFloat() * 0.4F + 0.8F);
            level.m_7731_(context.m_8083_(), state.m_61124_(BlockStateProperties.f_61443_, Boolean.TRUE), 11);
            cir.setReturnValue(InteractionResult.SUCCESS);
        }
    }
}
