/*
Taken and adjusted from Audaki Cart Engine, an excellent mod not available for MinecraftForge. This version of the mod was released
under CC0, and is incorporated under the mod as such. License text below.

---

Creative Commons Legal Code

CC0 1.0 Universal

    CREATIVE COMMONS CORPORATION IS NOT A LAW FIRM AND DOES NOT PROVIDE
    LEGAL SERVICES. DISTRIBUTION OF THIS DOCUMENT DOES NOT CREATE AN
    ATTORNEY-CLIENT RELATIONSHIP. CREATIVE COMMONS PROVIDES THIS
    INFORMATION ON AN "AS-IS" BASIS. CREATIVE COMMONS MAKES NO WARRANTIES
    REGARDING THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS
    PROVIDED HEREUNDER, AND DISCLAIMS LIABILITY FOR DAMAGES RESULTING FROM
    THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS PROVIDED
    HEREUNDER.

Statement of Purpose

The laws of most jurisdictions throughout the world automatically confer
exclusive Copyright and Related Rights (defined below) upon the creator
and subsequent owner(s) (each and all, an "owner") of an original work of
authorship and/or a database (each, a "Work").

Certain owners wish to permanently relinquish those rights to a Work for
the purpose of contributing to a commons of creative, cultural and
scientific works ("Commons") that the public can reliably and without fear
of later claims of infringement build upon, modify, incorporate in other
works, reuse and redistribute as freely as possible in any form whatsoever
and for any purposes, including without limitation commercial purposes.
These owners may contribute to the Commons to promote the ideal of a free
culture and the further production of creative, cultural and scientific
works, or to gain reputation or greater distribution for their Work in
part through the use and efforts of others.

For these and/or other purposes and motivations, and without any
expectation of additional consideration or compensation, the person
associating CC0 with a Work (the "Affirmer"), to the extent that he or she
is an owner of Copyright and Related Rights in the Work, voluntarily
elects to apply CC0 to the Work and publicly distribute the Work under its
terms, with knowledge of his or her Copyright and Related Rights in the
Work and the meaning and intended legal effect of CC0 on those rights.

1. Copyright and Related Rights. A Work made available under CC0 may be
protected by copyright and related or neighboring rights ("Copyright and
Related Rights"). Copyright and Related Rights include, but are not
limited to, the following:

  i. the right to reproduce, adapt, distribute, perform, display,
     communicate, and translate a Work;
 ii. moral rights retained by the original author(s) and/or performer(s);
iii. publicity and privacy rights pertaining to a person's image or
     likeness depicted in a Work;
 iv. rights protecting against unfair competition in regards to a Work,
     subject to the limitations in paragraph 4(a), below;
  v. rights protecting the extraction, dissemination, use and reuse of data
     in a Work;
 vi. database rights (such as those arising under Directive 96/9/EC of the
     European Parliament and of the Council of 11 March 1996 on the legal
     protection of databases, and under any national implementation
     thereof, including any amended or successor version of such
     directive); and
vii. other similar, equivalent or corresponding rights throughout the
     world based on applicable law or treaty, and any national
     implementations thereof.

2. Waiver. To the greatest extent permitted by, but not in contravention
of, applicable law, Affirmer hereby overtly, fully, permanently,
irrevocably and unconditionally waives, abandons, and surrenders all of
Affirmer's Copyright and Related Rights and associated claims and causes
of action, whether now known or unknown (including existing as well as
future claims and causes of action), in the Work (i) in all territories
worldwide, (ii) for the maximum duration provided by applicable law or
treaty (including future time extensions), (iii) in any current or future
medium and for any number of copies, and (iv) for any purpose whatsoever,
including without limitation commercial, advertising or promotional
purposes (the "Waiver"). Affirmer makes the Waiver for the benefit of each
member of the public at large and to the detriment of Affirmer's heirs and
successors, fully intending that such Waiver shall not be subject to
revocation, rescission, cancellation, termination, or any other legal or
equitable action to disrupt the quiet enjoyment of the Work by the public
as contemplated by Affirmer's express Statement of Purpose.

3. Public License Fallback. Should any part of the Waiver for any reason
be judged legally invalid or ineffective under applicable law, then the
Waiver shall be preserved to the maximum extent permitted taking into
account Affirmer's express Statement of Purpose. In addition, to the
extent the Waiver is so judged Affirmer hereby grants to each affected
person a royalty-free, non transferable, non sublicensable, non exclusive,
irrevocable and unconditional license to exercise Affirmer's Copyright and
Related Rights in the Work (i) in all territories worldwide, (ii) for the
maximum duration provided by applicable law or treaty (including future
time extensions), (iii) in any current or future medium and for any number
of copies, and (iv) for any purpose whatsoever, including without
limitation commercial, advertising or promotional purposes (the
"License"). The License shall be deemed effective as of the date CC0 was
applied by Affirmer to the Work. Should any part of the License for any
reason be judged legally invalid or ineffective under applicable law, such
partial invalidity or ineffectiveness shall not invalidate the remainder
of the License, and in such case Affirmer hereby affirms that he or she
will not (i) exercise any of his or her remaining Copyright and Related
Rights in the Work or (ii) assert any associated claims and causes of
action with respect to the Work, in either case contrary to Affirmer's
express Statement of Purpose.

4. Limitations and Disclaimers.

 a. No trademark or patent rights held by Affirmer are waived, abandoned,
    surrendered, licensed or otherwise affected by this document.
 b. Affirmer offers the Work as-is and makes no representations or
    warranties of any kind concerning the Work, express, implied,
    statutory or otherwise, including without limitation warranties of
    title, merchantability, fitness for a particular purpose, non
    infringement, or the absence of latent or other defects, accuracy, or
    the present or absence of errors, whether or not discoverable, all to
    the greatest extent permissible under applicable law.
 c. Affirmer disclaims responsibility for clearing rights of other persons
    that may apply to the Work or any use thereof, including without
    limitation any person's Copyright and Related Rights in the Work.
    Further, Affirmer disclaims responsibility for obtaining any necessary
    consents, permissions or other rights required for any use of the
    Work.
 d. Affirmer understands and acknowledges that Creative Commons is not a
    party to this document and has no duty or obligation with respect to
    this CC0 or use of the Work.
 */
package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.config.ModConfig;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecart.Type;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;

@Mixin(AbstractMinecart.class)
public abstract class AbstractMinecartEntityMixin extends Entity {

    public AbstractMinecartEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Shadow
    protected abstract boolean isRedstoneConductor(BlockPos pos);

    @Shadow
    public abstract Vec3 getPos(double x, double y, double z);

    @Shadow
    protected abstract void applyNaturalSlowdown();

    @Shadow
    protected abstract double getMaxSpeed();

    @Shadow
    public abstract Type getMinecartType();

    @Shadow
    private static Pair<Vec3i, Vec3i> exits(RailShape shape) {
        // This is just fake code, the shadowed private function will be executed
        return Pair.of(Direction.NORTH.m_122436_(), Direction.SOUTH.m_122436_());
    }

    @Unique
    private static boolean raspberryCore$isEligibleFastRail(BlockState state) {
        return state.m_60713_(Blocks.f_50156_) || (state.m_60713_(Blocks.f_50030_) && state.m_61143_(PoweredRailBlock.f_55215_));
    }

    @Unique
    private static RailShape raspberryCore$getRailShape(BlockState state) {
        if (!(state.m_60734_() instanceof BaseRailBlock railBlock))
            throw new IllegalArgumentException("No rail shape found");

        return state.m_61143_(railBlock.m_7978_());
    }

    @Inject(at = @At("HEAD"), method = "moveAlongTrack", cancellable = true)
    protected void moveAlongTrackOverwrite(BlockPos pos, BlockState state, CallbackInfo ci) {

        // We only change logic for rideable minecarts, so we don't break hopper/chest minecart creations
        if (this.getMinecartType() != Type.RIDEABLE) {
            return;
        }

        // We only change logic when the minecart is currently being ridden by a living entity (player/villager/mob)
        boolean hasLivingRider = this.m_146895_() instanceof LivingEntity;
        if (!hasLivingRider) {
            return;
        }

        // Only change Minecart logic if the config is enabled.
        if (!ModConfig.get().raspberryCartEngine) {
            return;
        }

        this.raspberryCore$modifiedMoveAlongTrack(pos, state);
        ci.cancel();
    }

    @Unique
    protected void raspberryCore$modifiedMoveAlongTrack(BlockPos startPos, BlockState state) {

        Level level = this.m_9236_();

        final double tps = 20.0;
        final double maxSpeed = ModConfig.get().raspberryCartMaxSpeed / tps;
        final double maxMomentum = maxSpeed * 5.0;
        final double vanillaMaxSpeed = 8.0 / tps;
        final double vanillaMaxMomentum = 40.0 / tps;

        m_183634_();

        double thisX = this.m_20185_();
        double thisY = this.m_20186_();
        double thisZ = this.m_20189_();

        Vec3 vec3 = this.getPos(thisX, thisY, thisZ);

        thisY = startPos.m_123342_();
        boolean onPoweredRail = false;
        boolean onBrakeRail = false;
        if (state.m_60713_(Blocks.f_50030_)) {
            onPoweredRail = state.m_61143_(PoweredRailBlock.f_55215_);
            onBrakeRail = !onPoweredRail;
        }

        double g = 0.0078125D;
        if (this.m_20069_()) {
            g *= 0.2D;
        }

        Vec3 momentum = this.m_20184_();
        RailShape railShape = raspberryCore$getRailShape(state);
        boolean isAscending = railShape.m_61745_();
        boolean isDiagonal = (railShape == RailShape.SOUTH_WEST || railShape == RailShape.NORTH_EAST ||
                railShape == RailShape.SOUTH_EAST || railShape == RailShape.NORTH_WEST);

        switch (railShape) {
            case ASCENDING_EAST -> {
                this.m_20256_(momentum.m_82520_(-g, 0.0D, 0.0D));
                ++thisY;
            }
            case ASCENDING_WEST -> {
                this.m_20256_(momentum.m_82520_(g, 0.0D, 0.0D));
                ++thisY;
            }
            case ASCENDING_NORTH -> {
                this.m_20256_(momentum.m_82520_(0.0D, 0.0D, g));
                ++thisY;
            }
            case ASCENDING_SOUTH -> {
                this.m_20256_(momentum.m_82520_(0.0D, 0.0D, -g));
                ++thisY;
            }
        }


        momentum = this.m_20184_();
        Pair<Vec3i, Vec3i> exitPair = exits(railShape);
        Vec3i exitRelPos1 = exitPair.getFirst();
        Vec3i exitRelPos2 = exitPair.getSecond();
        // The exit relative X and Z here can be either -1, 0 or 1
        //
        // Example for an EAST_WEST rail would be:
        // exitRelPos1.getX() = -1
        // exitRelPos2.getX() = 1
        // exitRelPos1.getZ() = 0
        // exitRelPos2.getZ() = 0
        // Therefore
        // exitDiffX = 2
        // exitDiffZ = 0
        // exitHypotenuse = 4
        //
        // Example for an SOUTH_EAST rail would be:
        // exitRelPos1.getX() = 0
        // exitRelPos2.getX() = 1
        // exitRelPos1.getZ() = 1
        // exitRelPos2.getZ() = 0
        // Therefore
        // exitDiffX = 1
        // exitDiffZ = -1
        // exitHypotenuse = 1.414
        //
        // Note: exitDiffX and exitDiffY can be either -1, 0, 1 or 2
        // (-2 isn’t possible, I think the south-east rule starts here)
        //
        // By some magic, this works out to find the correct new velocity depending on incoming velocity and rail shape
        double exitDiffX = exitRelPos2.m_123341_() - exitRelPos1.m_123341_();
        double exitDiffZ = exitRelPos2.m_123343_() - exitRelPos1.m_123343_();
        double exitHypotenuse = Math.sqrt(exitDiffX * exitDiffX + exitDiffZ * exitDiffZ);
        double k = momentum.f_82479_ * exitDiffX + momentum.f_82481_ * exitDiffZ;
        // Every rail shape has a "forward" movement according to the diffs using the exits()
        // If it’s backwards the direction is flipped.
        boolean movementIsBackwards = k < 0.0D;
        if (movementIsBackwards) {
            exitDiffX = -exitDiffX;
            exitDiffZ = -exitDiffZ;
        }

        double horizontalMomentum = Math.min(this.m_20184_().m_165924_(), maxMomentum);
        // The horizontal speed is redistributed using the hypotenuse of the exit rail positions
        this.m_20256_(new Vec3(horizontalMomentum * exitDiffX / exitHypotenuse, momentum.f_82480_, horizontalMomentum * exitDiffZ / exitHypotenuse));


        BlockPos exitPos;
        boolean exitIsAir;
        {
            BlockPos pos = isAscending ? startPos.m_7494_() : startPos;
            BlockPos exitPos1 = pos.m_121955_(exitRelPos1);
            if (level.m_8055_(new BlockPos(exitPos1.m_123341_(), exitPos1.m_123342_() - 1, exitPos1.m_123343_())).m_204336_(BlockTags.f_13034_)) {
                exitPos1 = exitPos1.m_7495_();
            }
            BlockPos exitPos2 = pos.m_121955_(exitRelPos2);
            if (level.m_8055_(new BlockPos(exitPos2.m_123341_(), exitPos2.m_123342_() - 1, exitPos2.m_123343_())).m_204336_(BlockTags.f_13034_)) {
                exitPos2 = exitPos2.m_7495_();
            }

            Vec3 posCenter = Vec3.m_82512_(pos);
            Vec3 exit1Center = Vec3.m_82512_(exitPos1);
            Vec3 exit2Center = Vec3.m_82512_(exitPos2);

            Vec3 momentumPos = posCenter.m_82549_(this.m_20184_()).m_82542_(1, 0, 1);
            exitPos = momentumPos.m_82554_(exit1Center.m_82542_(1, 0, 1)) < momentumPos.m_82554_(exit2Center.m_82542_(1, 0, 1)) ? exitPos1 : exitPos2;
            BlockState exitState = level.m_8055_(exitPos);
            exitIsAir = exitState.m_60713_(Blocks.f_50016_);
        }

        ArrayList<BlockPos> adjRailPositions = new ArrayList<>();
        Supplier<Double> calculateMaxSpeedForThisTick = () -> {

            double fallback = this.getMaxSpeed();

            if (!this.m_20160_())
                return fallback;

            if (this.m_20184_().m_165924_() < vanillaMaxSpeed)
                return fallback;

            if (!raspberryCore$isEligibleFastRail(state))
                return fallback;

            HashSet<BlockPos> checkedPositions = new HashSet<>();
            checkedPositions.add(startPos);


            BiFunction<BlockPos, RailShape, ArrayList<Pair<BlockPos, RailShape>>> checkNeighbors = (checkPos, checkRailShape) -> {

                Pair<Vec3i, Vec3i> nExitPair = exits(checkRailShape);

                ArrayList<Pair<BlockPos, RailShape>> newNeighbors = new ArrayList<>();

                BlockPos sourcePos = checkRailShape.m_61745_() ? checkPos.m_7494_() : checkPos;

                for (Vec3i nExitRelPos: List.of(nExitPair.getFirst(), nExitPair.getSecond())) {
                    BlockPos nPos = sourcePos.m_121955_(nExitRelPos);
                    if (level.m_8055_(new BlockPos(nPos.m_123341_(), nPos.m_123342_() - 1, nPos.m_123343_())).m_204336_(BlockTags.f_13034_)) {
                        nPos = nPos.m_7495_();
                    }

                    if (checkedPositions.contains(nPos))
                        continue;

                    BlockState nState = level.m_8055_(nPos);
                    if (!raspberryCore$isEligibleFastRail(nState))
                        return new ArrayList<>();

                    RailShape nShape = raspberryCore$getRailShape(nState);
                    boolean sameDiagonal = (railShape == RailShape.SOUTH_WEST && nShape == RailShape.NORTH_EAST
                            || railShape == RailShape.NORTH_EAST && nShape == RailShape.SOUTH_WEST
                            || railShape == RailShape.SOUTH_EAST && nShape == RailShape.NORTH_WEST
                            || railShape == RailShape.NORTH_WEST && nShape == RailShape.SOUTH_EAST);

                    if (nShape != railShape && !sameDiagonal)
                        return new ArrayList<>();

                    checkedPositions.add(nPos);
                    adjRailPositions.add(nPos);
                    // Adding the neighbor rail shape currently has no use, since we abort on rail shape change anyway
                    // Code stays as is for now so we can differentiate between types of rail shape changes later
                    newNeighbors.add(Pair.of(nPos, nShape));
                }

                return newNeighbors;
            };


            ArrayList<Pair<BlockPos, RailShape>> newNeighbors = checkNeighbors.apply(startPos, railShape);

            double checkFactor = (isDiagonal || isAscending) ? 2. : 1.;
            final int cutoffPoint = 3;
            int sizeToCheck = (int)(2 * (cutoffPoint + (checkFactor * maxSpeed)));
            sizeToCheck -= (sizeToCheck % 2);

            while (!newNeighbors.isEmpty() && adjRailPositions.size() < sizeToCheck) {
                ArrayList<Pair<BlockPos, RailShape>> tempNewNeighbors = new ArrayList<>(newNeighbors);
                newNeighbors.clear();

                for (Pair<BlockPos, RailShape> newNeighbor : tempNewNeighbors) {
                    ArrayList<Pair<BlockPos, RailShape>> result = checkNeighbors.apply(newNeighbor.getFirst(), newNeighbor.getSecond());

                    // Abort when one direction is empty
                    if (result.isEmpty()) {
                        newNeighbors.clear();
                        break;
                    }

                    newNeighbors.addAll(result);
                }
            }

            int railCountEachDirection = adjRailPositions.size() / 2;
            final double cutoffSpeedPerSec = 20.;
            switch (railCountEachDirection) {
                case 0:
                case 1:
                    return fallback;
                case 2:
                    return 12. / tps;
                case 3:
                    return cutoffSpeedPerSec / tps;
                default:
            }

            int railCountPastBegin = railCountEachDirection - cutoffPoint;
            return (cutoffSpeedPerSec + ((20. / checkFactor) * railCountPastBegin)) / tps;
        };

        double maxSpeedForThisTick = Math.min(calculateMaxSpeedForThisTick.get(), maxSpeed);
        if (isDiagonal || isAscending) {
            // Diagonal and Ascending/Descending is 1.4142 times faster, we correct this here
            maxSpeedForThisTick = Math.min(maxSpeedForThisTick, 0.7071 * maxSpeed);
        }

        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Vec3 playerDeltaMovement = entity.m_20184_();
            double m = playerDeltaMovement.m_165925_();
            double n = this.m_20184_().m_165925_();
            if (m > 1.0E-4D && n < 0.01D) {
                this.m_20256_(this.m_20184_().m_82520_(playerDeltaMovement.f_82479_ * 0.1D, 0.0D, playerDeltaMovement.f_82481_ * 0.1D));
                onBrakeRail = false;
            }
        }


        /*
        Braking Algorithm
        Original:
            double o;
            if (bl2) {
                o = this.getDeltaMovement().horizontalDistance();
                if (o < 0.03) {
                    this.setDeltaMovement(Vec3.ZERO);
                } else {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
                }
            }
         */
        if (onBrakeRail) {
            momentum = this.m_20184_();
            horizontalMomentum = momentum.m_165924_();

            if (horizontalMomentum < 0.03) {
                this.m_20256_(Vec3.f_82478_);
            } else {

                if (horizontalMomentum > vanillaMaxSpeed) {
                    double ratioToSlowdown = vanillaMaxSpeed / horizontalMomentum;
                    this.m_20256_(momentum.m_82542_(ratioToSlowdown, 1., ratioToSlowdown));
                }

                double brakeFactor = 0.59;
                this.m_20256_(this.m_20184_().m_82542_(brakeFactor, 0., brakeFactor));
            }
        }

        double p = (double) startPos.m_123341_() + 0.5D + (double) exitRelPos1.m_123341_() * 0.5D;
        double q = (double) startPos.m_123343_() + 0.5D + (double) exitRelPos1.m_123343_() * 0.5D;
        double r = (double) startPos.m_123341_() + 0.5D + (double) exitRelPos2.m_123341_() * 0.5D;
        double s = (double) startPos.m_123343_() + 0.5D + (double) exitRelPos2.m_123343_() * 0.5D;
        exitDiffX = r - p;
        exitDiffZ = s - q;
        double x;
        double v;
        double w;
        if (exitDiffX == 0.0D) {
            x = thisZ - (double) startPos.m_123343_();
        } else if (exitDiffZ == 0.0D) {
            x = thisX - (double) startPos.m_123341_();
        } else {
            v = thisX - p;
            w = thisZ - q;
            x = (v * exitDiffX + w * exitDiffZ) * 2.0D;
        }

        thisX = p + exitDiffX * x;
        thisZ = q + exitDiffZ * x;

        v = this.m_20160_() ? 0.75D : 1.0D;
        w = maxSpeedForThisTick;
        momentum = this.m_20184_();
        // The clamp here differentiates between momentum and actual allowed speed in this tick
        Vec3 movement = new Vec3(Mth.m_14008_(v * momentum.f_82479_, -w, w), 0.0D, Mth.m_14008_(v * momentum.f_82481_, -w, w));

        double extraY = 0;
        if (railShape.m_61745_()) {
            if (exitPos.m_123342_() > startPos.m_123342_()) {
//                System.out.println("is higher!");
                extraY = (int) (0.5 + movement.m_165924_());
                thisY += extraY;
            }
        }

        this.m_6034_(thisX, thisY, thisZ);
        this.m_6478_(MoverType.SELF, movement);

//        System.out.println("Actual: " + movement.horizontalDistance()
//                + " " + level.getBlockState(new BlockPos(Mth.floor(this.getX()), Mth.floor(this.getY() - 2.), Mth.floor(this.getZ()))).is(BlockTags.RAILS)
//                + " " + level.getBlockState(new BlockPos(Mth.floor(this.getX()), Mth.floor(this.getY() - 1.), Mth.floor(this.getZ()))).is(BlockTags.RAILS)
//                + " " + level.getBlockState(new BlockPos(Mth.floor(this.getX()), Mth.floor(this.getY() - 0.), Mth.floor(this.getZ()))).is(BlockTags.RAILS)
//                + " " + level.getBlockState(new BlockPos(Mth.floor(this.getX()), Mth.floor(this.getY() + 1.), Mth.floor(this.getZ()))).is(BlockTags.RAILS));

        {
            // Snap down after extra snap ups on ascending rails
            // Also snap down on descending rails
            if (railShape.m_61745_()
                    && !level.m_8055_(new BlockPos(Mth.m_14107_(this.m_20185_()), Mth.m_14107_(this.m_20186_()), Mth.m_14107_(this.m_20189_()))).m_204336_(BlockTags.f_13034_)
                    && !level.m_8055_(new BlockPos(Mth.m_14107_(this.m_20185_()), Mth.m_14107_(this.m_20186_() - 1.), Mth.m_14107_(this.m_20189_()))).m_204336_(BlockTags.f_13034_)) {

                if (level.m_8055_(new BlockPos(Mth.m_14107_(this.m_20185_()), Mth.m_14107_(this.m_20186_() - 2.), Mth.m_14107_(this.m_20189_()))).m_204336_(BlockTags.f_13034_)) {
                    this.m_6034_(this.m_20185_(), this.m_20186_() - 1, this.m_20189_());
                } else if (level.m_8055_(new BlockPos(Mth.m_14107_(this.m_20185_()), Mth.m_14107_(this.m_20186_() - 3.), Mth.m_14107_(this.m_20189_()))).m_204336_(BlockTags.f_13034_)) {
                    this.m_6034_(this.m_20185_(), this.m_20186_() - 2, this.m_20189_());
                }
            }

            // Old vanilla code to snap down on descending rails (only the descending exit had a different Y rel pos)
//        if (exitRelPos1.getY() != 0 && Mth.floor(this.getX()) - startPos.getX() == exitRelPos1.getX() && Mth.floor(this.getZ()) - startPos.getZ() == exitRelPos1.getZ()) {
//            this.setPos(this.getX(), this.getY() + (double) exitRelPos1.getY(), this.getZ());
//        } else if (exitRelPos2.getY() != 0 && Mth.floor(this.getX()) - startPos.getX() == exitRelPos2.getX() && Mth.floor(this.getZ()) - startPos.getZ() == exitRelPos2.getZ()) {
//            this.setPos(this.getX(), this.getY() + (double) exitRelPos2.getY(), this.getZ());
//        }
        }



        this.applyNaturalSlowdown();

        // Todo: 100% understand this vanilla code block & rename variables
        Vec3 vec3d4 = this.getPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (vec3d4 != null && vec3 != null) {
            double aa = (vec3.f_82480_ - vec3d4.f_82480_) * 0.05D;
            momentum = this.m_20184_();
            horizontalMomentum = momentum.m_165924_();
            if (horizontalMomentum > 0.0D) {
                this.m_20256_(momentum.m_82542_((horizontalMomentum + aa) / horizontalMomentum, 1.0D, (horizontalMomentum + aa) / horizontalMomentum));
            }

            this.m_6034_(this.m_20185_(), vec3d4.f_82480_, this.m_20189_());
        }

        // Todo: 100% understand this vanilla code block & rename variables
        int ac = Mth.m_14107_(this.m_20185_());
        int ad = Mth.m_14107_(this.m_20189_());
        if (ac != startPos.m_123341_() || ad != startPos.m_123343_()) {
            momentum = this.m_20184_();
            horizontalMomentum = momentum.m_165924_();
            this.m_20334_(
                    horizontalMomentum * Mth.m_14008_(ac - startPos.m_123341_(), -1.0D, 1.0D),
                    momentum.f_82480_,
                    horizontalMomentum * Mth.m_14008_(ad - startPos.m_123343_(), -1.0D, 1.0D));
        }


        // Give speedup or kickstart when standing at block + powered rail
        if (onPoweredRail) {
            momentum = this.m_20184_();
            horizontalMomentum = momentum.m_165924_();
            final double basisAccelerationPerTick = 0.021D;
            if (horizontalMomentum > 0.01D) {

                if (this.m_20160_()) {
                    // TODO: Rewrite the comment/naming so it makes more sense (very confusing since TPS is 20 and we can only skip 1 block with current speeds)

                    // Based on a 10 ticks per second basis spent per powered block we calculate a fair acceleration per tick
                    // due to spending less ticks per powered block on higher speeds (and even skipping blocks)
                    final double basisTicksPerSecond = 10.0D;
                    // Tps = Ticks per second
                    final double tickMovementForBasisTps = 1.0D / basisTicksPerSecond;
                    final double maxSkippedBlocksToConsider = 3.0D;


                    double acceleration = basisAccelerationPerTick;
                    final double distanceMovedHorizontally = movement.m_165924_();

                    if (distanceMovedHorizontally > tickMovementForBasisTps) {
                        acceleration *= Math.min((1.0D + maxSkippedBlocksToConsider) * basisTicksPerSecond, distanceMovedHorizontally / tickMovementForBasisTps);

                        // Add progressively slower (or faster) acceleration for higher speeds;
                        double highspeedFactor = 1.0D + Mth.m_14008_(-0.45D * (distanceMovedHorizontally / tickMovementForBasisTps / basisTicksPerSecond), -0.7D, 2.0D);
                        acceleration *= highspeedFactor;
                    }
                    this.m_20256_(momentum.m_82520_(acceleration * (momentum.f_82479_ / horizontalMomentum), 0.0D, acceleration * (momentum.f_82481_ / horizontalMomentum)));
                }
                else {
                    this.m_20256_(momentum.m_82520_(momentum.f_82479_ / horizontalMomentum * 0.06D, 0.0D, momentum.f_82481_ / horizontalMomentum * 0.06D));
                }


            } else {
                momentum = this.m_20184_();
                double ah = momentum.f_82479_;
                double ai = momentum.f_82481_;
                final double railStopperAcceleration = basisAccelerationPerTick * 16.0D;
                if (railShape == RailShape.EAST_WEST) {
                    if (this.isRedstoneConductor(startPos.m_122024_())) {
                        ah = railStopperAcceleration;
                    } else if (this.isRedstoneConductor(startPos.m_122029_())) {
                        ah = -railStopperAcceleration;
                    }
                } else {
                    if (railShape != RailShape.NORTH_SOUTH) {
                        return;
                    }

                    if (this.isRedstoneConductor(startPos.m_122012_())) {
                        ai = railStopperAcceleration;
                    } else if (this.isRedstoneConductor(startPos.m_122019_())) {
                        ai = -railStopperAcceleration;
                    }
                }

                this.m_20334_(ah, momentum.f_82480_, ai);
            }
        }

        // TODO: Falling is still inconsistent, is it a vanilla inconsistency?
//        if (exitIsAir) {
//            momentum = this.getDeltaMovement();
//            horizontalMomentum = momentum.horizontalDistance();
//            if (horizontalMomentum > vanillaMaxSpeed) {
//                double ratioToSlowdown = vanillaMaxSpeed / horizontalMomentum;
//                this.setDeltaMovement(momentum.multiply(ratioToSlowdown, 1., ratioToSlowdown));
//            }
//        }
    }
}