package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.compat.vanillabackport.leash.Leashable;
import cc.cassian.raspberry.config.ModConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(ClientPacketListener.class)
public class ClientPacketListenerMixin {

    @Shadow
    private ClientLevel level;

    @Final
    @Shadow
    private Minecraft minecraft;

    @Inject(method = "handleEntityLinkPacket", at = @At("HEAD"), cancellable = true)
    private void raspberry$onEntityLinkPacket(ClientboundSetEntityLinkPacket packet, CallbackInfo ci) {
        if (!ModConfig.get().backportLeash) return;

        if (!this.minecraft.m_18695_()) {
            return;
        }
        if (this.level == null) return;

        Entity entity = this.level.m_6815_(packet.m_133172_());

        if (entity instanceof Leashable leashable) {
            ci.cancel();

            int destId = packet.m_133175_();

            if (destId == 0) {
                if (entity instanceof Mob mob) {
                    ((MobAccessor) mob).raspberry$setDelayedLeashHolderId(0);
                }
                leashable.raspberry$dropLeash(false, false);
            } else {
                if (entity instanceof Mob mob) {
                    ((MobAccessor) mob).raspberry$setDelayedLeashHolderId(destId);
                } else {
                    leashable.raspberry$setDelayedLeashHolderId(destId);
                }

                Entity target = this.level.m_6815_(destId);
                if (target != null) {
                    leashable.raspberry$setLeashedTo(target, false);
                }
            }
        }
    }
}