package com.simibubi.create.compat.emi;

import com.mojang.blaze3d.vertex.PoseStack;

import com.mojang.math.Vector3f;
import com.simibubi.create.foundation.gui.element.GuiGameElement;

import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.DrawableWidget.DrawableWidgetConsumer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

import javax.annotation.Nullable;

import java.util.List;

public record RenderedBlock(BlockState state) implements EmiRenderable, DrawableWidgetConsumer {
	@Nullable
	public static RenderedBlock of(EmiIngredient ingredient) {
		List<EmiStack> stacks = ingredient.getEmiStacks();
		if (stacks.size() == 0)
			return null;
		return of(stacks.get(0));
	}

	@Nullable
	public static RenderedBlock of(EmiStack stack) {
		ItemStack item = stack.getItemStack();
		if (item.m_41619_())
			return null;
		if (!(item.m_41720_() instanceof BlockItem block))
			return null;
		return new RenderedBlock(block.m_40614_().m_49966_());
	}
	@Override
	public void render(PoseStack matrixStack, int x, int y, float delta) {
		matrixStack.m_85836_();
		matrixStack.m_85837_(74, 51, 100);
		matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-15.5f));
		matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(22.5f));
		int scale = 20;

		GuiGameElement.of(state)
				.lighting(CreateEmiAnimations.DEFAULT_LIGHTING)
				.scale(scale)
				.render(matrixStack);

		matrixStack.m_85849_();
	}
}
