package cc.cassian.raspberry.compat.emi;

import cc.cassian.raspberry.RaspberryMod;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;

public class EmiEtchingRecipe extends EmiAbstractSmithingRecipe {

    public EmiEtchingRecipe(EmiIngredient input1, EmiStack input2, EmiStack output, ResourceLocation id) {
        super(input1, input2, output, id);
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return EmiCompat.ANVIL;
    }

    static void addRunes(EmiRegistry emiRegistry) {
        for (String dye : ALL_RUNES) {
            var enchantedGear = new ItemStack(Items.f_42473_);
            enchantedGear.m_41663_(Enchantments.f_44969_, 1);
            var runedGear = enchantedGear.m_41777_();
            var compound = runedGear.m_41784_();
            var quark = new CompoundTag();
            var rune = Registry.f_122827_.m_7745_(new ResourceLocation("quark", "%s_rune".formatted(dye)));
            quark.m_128359_("id", "quark:%s_rune".formatted(dye));
            quark.m_128344_("Count", Byte.parseByte("64"));
            compound.m_128365_("quark:RuneColor", quark);
            compound.m_128344_("quark:RuneAttached", Byte.parseByte("1"));
            runedGear.m_41751_(compound);
            emiRegistry.addRecipe(new EmiEtchingRecipe(
                    EmiStack.of(enchantedGear),
                    EmiStack.of(new ItemStack(rune)),
                    EmiStack.of(runedGear),
                    RaspberryMod.locate("/etching/"+dye)
            ));
        }
    }

    private final static String[] ALL_RUNES = {
            "white",
            "light_gray",
            "gray",
            "black",
            "brown",
            "red",
            "orange",
            "yellow",
            "lime",
            "green",
            "cyan",
            "light_blue",
            "blue",
            "purple",
            "magenta",
            "pink",
            "rainbow"
    };
}
