/*
 * Copyright (c) 2022 Team Galena

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package cc.cassian.raspberry.compat.oreganized;

import F;
import cc.cassian.raspberry.config.ModConfig;
import cc.cassian.raspberry.registry.RaspberryAttributes;
import cc.cassian.raspberry.registry.RaspberryParticleTypes;
import cc.cassian.raspberry.registry.RaspberrySoundEvents;
import cc.cassian.raspberry.registry.RaspberryTags;
import com.google.common.collect.Multimap;
import galena.oreganized.content.item.SilverMirrorItem;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

import javax.annotation.Nullable;
import java.util.UUID;

public class OreganizedEvents {
    @SubscribeEvent
    public static void onItemAttributes(ItemAttributeModifierEvent event) {
        var stack = event.getItemStack();
        var mods = event.getModifiers();

        if (event.getSlotType() != EquipmentSlot.MAINHAND) return;

        if (stack.m_204117_(RaspberryTags.HAS_KINETIC_DAMAGE) && !mods.containsKey(RaspberryAttributes.KINETIC_DAMAGE.get())) {
            var damage = stack.m_41720_() instanceof DiggerItem item
                    ? item.m_41008_()
                    : stack.m_41720_() instanceof SwordItem item
                    ? item.m_43299_()
                    : 2.0F;
            event.addModifier(RaspberryAttributes.KINETIC_DAMAGE.get(), new AttributeModifier(
                    UUID.fromString("0191ff58-54d7-711d-8a94-692379277c24"), "Kinetic Damage", damage / 3, AttributeModifier.Operation.ADDITION)
            );
        }
    }

    @SubscribeEvent
    public static void onHurtEvent(LivingAttackEvent event) {
        LivingEntity victim = event.getEntity();
        if (!(event.getSource().m_7640_() instanceof Player perp)) return;
        if (!victim.m_21222_()) return;
        if (!(perp.m_21205_().m_41720_() instanceof SilverMirrorItem)) return;

        Level level = victim.f_19853_;
        BlockPos origin = victim.m_20183_();
        BlockPos closestSilver = findNearestSilverBlock(level, origin);
        if (closestSilver == null) return;
        Vec3 targetPos = Vec3.m_82512_(closestSilver);
        Vec3 velocity = targetPos.m_82546_(victim.m_20182_()).m_82541_();
        level.m_6263_((Player) null, perp.m_20185_(), perp.m_20186_(), perp.m_20189_(), RaspberrySoundEvents.SILVER_HIT.get(), perp.m_5720_(),
                (float) ModConfig.get().mirrorVolumeModifier, 1.0F + (float) (perp.m_217043_().m_188583_() * 0.35));

        for (int i = 0; i < 8; i++) {
            double offsetX = (victim.m_217043_().m_188500_() - (0.5 * victim.m_20205_())) * 1.5;
            double offsetY = victim.m_217043_().m_188500_() * victim.m_20206_();
            double offsetZ = (victim.m_217043_().m_188500_() - (0.5 * victim.m_20205_())) * 1.5;
            Vec3 finalVelocity = velocity.m_82490_(victim.m_217043_().m_188500_() * 0.225);

            Vec3 spawnPos = victim.m_20182_().m_82520_(offsetX, offsetY, offsetZ);
            level.m_7106_(RaspberryParticleTypes.MIRROR.get(),
                    spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_,
                    finalVelocity.f_82479_, finalVelocity.f_82480_, finalVelocity.f_82481_);
        }
    }

    @Nullable
    private static BlockPos findNearestSilverBlock(Level level, BlockPos origin) {
        BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
        BlockPos closest = null;
        double closestDistSq = Double.MAX_VALUE;

        int radius = ModConfig.get().mirrorParticleSearchRadius;
        int verticalRadius = ModConfig.get().mirrorVerticalParticleSearchRadius;

        int radiusSq = radius * radius;

        for (int dx = -radius; dx <= radius; dx++) {
            for (int dy = -verticalRadius; dy <= verticalRadius; dy++) {
                for (int dz = -radius; dz <= radius; dz++) {
                    if (dx * dx + dy * dy + dz * dz > radiusSq) continue;

                    searchPos.m_122178_(origin.m_123341_() + dx, origin.m_123342_() + dy, origin.m_123343_() + dz);
                    if (!level.m_46749_(searchPos)) continue;
                    if (!level.m_8055_(searchPos).m_204336_(RaspberryTags.MIRROR_DETECTABLES)) continue;

                    double distSq = searchPos.m_123331_(origin);
                    if (distSq < closestDistSq) {
                        closestDistSq = distSq;
                        closest = searchPos.m_7949_();
                    }
                }
            }
        }
        return closest;
    }

}
