/* The MIT License (MIT)

Copyright (c) 2025 

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */


package cc.cassian.raspberry.compat.vanillabackport.leash;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

import cc.cassian.raspberry.mixin.minecraft.EntityAccessor;

public class InterpolationHandler {
    private final Entity entity;
    private final int interpolationSteps;
    private final InterpolationData data = new InterpolationData(0, Vec3.f_82478_, 0.0F, 0.0F);
    @Nullable private Vec3 previousTickPosition;
    @Nullable private Vec2 previousTickRot;

    public InterpolationHandler(Entity entity, int steps) {
        this.interpolationSteps = steps;
        this.entity = entity;
    }

    public void interpolateTo(Vec3 position, float y, float x) {
        if (this.interpolationSteps == 0) {
            this.entity.m_20343_(position.f_82479_, position.f_82480_, position.f_82481_);
            this.entity.m_146922_(y);
            this.entity.m_146926_(x);
            this.entity.m_146867_();
            ((EntityAccessor) this.entity).callReapplyPosition();
            this.cancel();
        } else {
            this.data.steps = this.interpolationSteps;
            this.data.position = position;
            this.data.yRot = y;
            this.data.xRot = x;
            this.previousTickPosition = this.entity.m_20182_();
            this.previousTickRot = new Vec2(this.entity.m_146909_(), this.entity.m_146908_());
        }
    }

    public boolean hasActiveInterpolation() {
        return this.data.steps > 0;
    }

    public void interpolate() {
        if (!this.hasActiveInterpolation()) {
            this.cancel();
        } else {
            double progress = 1.0 / this.data.steps;
            if (this.previousTickPosition != null) {
                Vec3 movement = this.entity.m_20182_().m_82546_(this.previousTickPosition);
                if (this.entity.f_19853_.m_45756_(this.entity, ((EntityAccessor) this.entity).getDimensions().m_20393_(this.data.position.m_82549_(movement)))) {
                    this.data.addDelta(movement);
                }
            }

            if (this.previousTickRot != null) {
                float yRot = this.entity.m_146908_() - this.previousTickRot.f_82471_;
                float xRot = this.entity.m_146909_() - this.previousTickRot.f_82470_;
                this.data.addRotation(yRot, xRot);
            }

            double x = Mth.m_14139_(progress, this.entity.m_20185_(), this.data.position.f_82479_);
            double y = Mth.m_14139_(progress, this.entity.m_20186_(), this.data.position.f_82480_);
            double z = Mth.m_14139_(progress, this.entity.m_20189_(), this.data.position.f_82481_);
            Vec3 position = new Vec3(x, y, z);

            float yRot = Mth.m_14189_((float) progress, this.entity.m_146908_(), this.data.yRot);
            float xRot = (float)Mth.m_14139_(progress, this.entity.m_146909_(), this.data.xRot);

            this.entity.m_146884_(position);
            ((EntityAccessor) this.entity).callSetRot(yRot, xRot);

            this.data.decrease();
            this.previousTickPosition = position;
            this.previousTickRot = new Vec2(this.entity.m_146909_(), this.entity.m_146908_());
        }
    }

    public void cancel() {
        this.data.steps = 0;
        this.previousTickPosition = null;
        this.previousTickRot = null;
    }

    static class InterpolationData {
        protected int steps;
        Vec3 position;
        float yRot;
        float xRot;

        InterpolationData(int steps, Vec3 position, float yRot, float xRot) {
            this.steps = steps;
            this.position = position;
            this.yRot = yRot;
            this.xRot = xRot;
        }

        public void decrease() {
            this.steps--;
        }

        public void addDelta(Vec3 vec3) {
            this.position = this.position.m_82549_(vec3);
        }

        public void addRotation(float yRot, float xRot) {
            this.yRot += yRot;
            this.xRot += xRot;
        }
    }
}