package cc.cassian.raspberry.entity;

import cc.cassian.raspberry.config.ModConfig;
import cc.cassian.raspberry.registry.RaspberryEntityTypes;
import cc.cassian.raspberry.registry.RaspberryItems;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class Ashball extends ThrowableItemProjectile {
    public Ashball(EntityType<Ashball> entityType, Level level) {
        super(entityType, level);
    }

    public Ashball(Level level, LivingEntity shooter) {
        super(RaspberryEntityTypes.ASHBALL.get(), shooter, level);
    }

    public Ashball(Level level, double x, double y, double z) {
        super(RaspberryEntityTypes.ASHBALL.get(), x, y, z, level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19796_.m_188499_() && ModConfig.get().thrownItemParticles)
            this.f_19853_.m_7106_(getParticle(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    @Override
    protected Item m_7881_() {
        return RaspberryItems.ASHBALL.get();
    }

    private ParticleOptions getParticle() {
        return ModParticles.ASH_PARTICLE.get();
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 3) {
            ParticleOptions particleOptions = this.getParticle();

            for (int i = 0; i < 16; i++) {
                this.f_19853_.m_7106_(particleOptions, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity livingEntity) {
            if (livingEntity.m_5801_()) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100));
            }
        }
        entity.m_6469_(DamageSource.m_19361_(this, this.m_37282_()), 0);
    }

    @Override
    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_(this, (byte)3);
            this.m_146870_();
        }
    }

    /**
     * Gets the amount of gravity to apply to the thrown entity with each tick.
     */
    @Override
    protected float m_7139_() {
        return 0.06F;
    }
}
