package cc.cassian.raspberry.events;

import cc.cassian.raspberry.ModCompat;
import cc.cassian.raspberry.registry.RaspberryMobEffects;
import cc.cassian.raspberry.registry.RaspberryTags;
import cofh.core.init.CoreMobEffects;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;

public class AftershockEvent {

    /**
     * Adds aftershock to Copper Armor.
     * Implemented via Forge event and mixin into CoFH Core.
     */
    public static void electrify(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        int copperCount = 0;
        if (entity instanceof LivingEntity player) {
            for (ItemStack armorSlot : entity.m_6168_()) {
                if (armorSlot.m_204117_(RaspberryTags.COPPER_ARMOR)) {
                    copperCount++;
                }
            }
            copperCount--;
            if (copperCount >= 0) {
                if (!ModCompat.COFH_CORE)
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, copperCount, false, false, false));
                player.m_7292_(new MobEffectInstance(RaspberryMobEffects.AFTERSHOCK.get(), 6000, copperCount, false, false, true));
            }
        }
    }

    /**
     * Adds lightning resistance to Copper Armor.
     * Requires CoFH Core.
     * Implemented via mixin.
     */
    public static void resist(LivingEntity entity) {
        int copperCount = 0;
        if (entity instanceof LocalPlayer) {
            return;
        }
        for (ItemStack armorSlot : entity.m_6168_()) {
            if (armorSlot.m_204117_(RaspberryTags.COPPER_ARMOR)) {
                copperCount++;
            }
        }
        copperCount--;
        if (copperCount >= 0) {
            entity.m_7292_(new MobEffectInstance(CoreMobEffects.LIGHTNING_RESISTANCE.get(), 200, 0, false, false, true));
        }
    }
}
