package cc.cassian.raspberry.items;

import cc.cassian.raspberry.entity.Ashball;
import cc.cassian.raspberry.entity.RoseGoldBombEntity;
import cc.cassian.raspberry.registry.RaspberrySoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RoseGoldBombItem extends Item {
    public RoseGoldBombItem(Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        level.m_6263_(
                null,
                player.m_20185_(),
                player.m_20186_(),
                player.m_20189_(),
                RaspberrySoundEvents.ASHBALL_THROW.get(),
                SoundSource.NEUTRAL,
                0.5F,
                0.4F / (level.m_213780_().m_188501_() * 0.4F + 0.8F)
        );
        if (!level.f_46443_) {
            RoseGoldBombEntity ashball = new RoseGoldBombEntity(level, player);
            ashball.m_37446_(itemStack);
            ashball.m_37251_(player, player.m_146909_(), player.m_146908_(), 0.0F, 1.5F, 1.0F);
            level.m_7967_(ashball);
        }

        player.m_36246_(Stats.f_12982_.m_12902_(this));
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }

        return InteractionResultHolder.m_19092_(itemStack, level.m_5776_());
    }
}
