package cc.cassian.raspberry.items;

import cc.cassian.raspberry.entity.SwapArrowEntity;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.world.entity.LivingEntity;

import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class SwapArrowItem extends ArrowItem {
    public SwapArrowItem(Item.Properties builder) {
        super(builder);
        DispenserBlock.m_52672_(this, new AbstractProjectileDispenseBehavior() {
            // Copy of execute function
            @Override
            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                Level level = source.m_7727_();
                Position position = DispenserBlock.m_52720_(source);
                Direction direction = source.m_6414_().m_61143_(DispenserBlock.f_52659_);
                Projectile projectile = this.m_6895_(level, position, stack);

                // Added dispenser position so it can swap position with hit entity
                projectile.getPersistentData().m_128356_("DispenserSourcePosition",source.m_7961_().m_121878_());

                projectile.m_6686_(direction.m_122429_(), direction.m_122430_() + 0.1F, direction.m_122431_(), this.m_7104_(), this.m_7101_());
                level.m_7967_(projectile);
                stack.m_41774_(1);
                return stack;
            }
            protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                SwapArrowEntity swap_arrow = new SwapArrowEntity(level, position.m_7096_(), position.m_7098_(), position.m_7094_());
                swap_arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return swap_arrow;
            }
        });
    }

    @Override
    public AbstractArrow m_6394_(Level worldIn, ItemStack stack, LivingEntity shooter) {
        return new SwapArrowEntity(worldIn, shooter);
    }
}
