package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.config.ModConfig;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(DragonFireball.class)
public abstract class DragonFireballMixin extends AbstractHurtingProjectile {

    protected DragonFireballMixin(net.minecraft.world.entity.EntityType<? extends AbstractHurtingProjectile> entityType, net.minecraft.world.level.Level level) {
        super(entityType, level);
    }

    @Override
    public boolean m_6087_() {
        return ModConfig.get().ghastDragonFireball || super.m_6087_();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!ModConfig.get().ghastDragonFireball) {
            return super.m_6469_(source, amount);
        }

        if (this.m_6673_(source)) {
            return false;
        } else {
            this.m_5834_();
            Entity attacker = source.m_7639_();
            
            if (attacker != null) {
                Vec3 look = attacker.m_20154_();
                this.m_20256_(look);
                this.f_36813_ = look.f_82479_ * 0.1D;
                this.f_36814_ = look.f_82480_ * 0.1D;
                this.f_36815_ = look.f_82481_ * 0.1D;
                this.m_5602_(attacker);
                return true;
            } else {
                return false;
            }
        }
    }

    @Inject(method = "onHit", at = @At("HEAD"), cancellable = true)
    private void raspberry$onHit(HitResult result, CallbackInfo ci) {
        if (!ModConfig.get().ghastDragonFireball) {
            return; 
        }
        ci.cancel();

        Entity owner = this.m_37282_();
            
        if (result instanceof EntityHitResult entityHit) {
            Entity target = entityHit.m_82443_();
            
            DamageSource src = new IndirectEntityDamageSource("fireball", this, owner).m_19366_();

            if (target instanceof Ghast) {
                target.m_6469_(src, 30.0F); 
            } else {
                target.m_6469_(src, 6.0F);  
            }
            
            this.m_146870_();
            return;
        }

        if (!this.f_19853_.f_46443_) {
            var cloud = new net.minecraft.world.entity.AreaEffectCloud(
                this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());

            if (owner instanceof net.minecraft.world.entity.LivingEntity living) {
                cloud.m_19718_(living);
            }

            cloud.m_19724_(net.minecraft.core.particles.ParticleTypes.f_123799_);
            cloud.m_19712_(3.0F);
            cloud.m_19734_(100); 
            cloud.m_19738_((7.0F - cloud.m_19743_()) / cloud.m_19748_());

            cloud.m_19716_(new net.minecraft.world.effect.MobEffectInstance(
                    net.minecraft.world.effect.MobEffects.f_19602_, 1, 1));

            this.f_19853_.m_46796_(2006, this.m_20183_(), this.m_20067_() ? -1 : 1);
            
            this.f_19853_.m_7967_(cloud);
        }

        this.m_146870_();
    }

}