package cc.cassian.raspberry.mixin.vc_gliders;

import cc.cassian.raspberry.ModCompat;
import cc.cassian.raspberry.compat.SurvivalityCompat;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.venturecraft.gliders.common.item.GliderItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(GliderItem.class)
public class GliderItemMixin {
    @Inject(
            method = {"use"},
            at = {@At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/InteractionResultHolder;fail(Ljava/lang/Object;)Lnet/minecraft/world/InteractionResultHolder;"
            )}
    )
    private void swapArmorViaSurvivality(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (ModCompat.SURVIVALITY && SurvivalityCompat.swappingEnabled()) {
            SurvivalityCompat.swap(user);
            if (!world.f_46443_) {
                user.m_36246_(Stats.f_12982_.m_12902_((GliderItem)(Object)this));
            }
        }

    }
}
