package cc.cassian.raspberry.worldgen;

import cc.cassian.raspberry.registry.RaspberryBlocks;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.CaveSurface;

public class RaspberyFeatures {

    public static final SimpleWeightedRandomList.Builder<?> list = SimpleWeightedRandomList.m_146263_().m_146271_(Blocks.f_152542_.m_49966_(), 4).m_146271_(Blocks.f_152541_.m_49966_(), 7).m_146271_(RaspberryBlocks.RED_MOSS_CARPET.defaultBlockState(), 25).m_146271_(Blocks.f_50034_.m_49966_(), 50).m_146271_(Blocks.f_50359_.m_49966_(), 10);

    public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> RED_MOSS_VEGETATION = FeatureUtils.m_206488_("red_moss_vegetation", Feature.f_65741_, new SimpleBlockConfiguration(new WeightedStateProvider((SimpleWeightedRandomList.Builder<BlockState>) list)));

    public static final Holder<ConfiguredFeature<VegetationPatchConfiguration, ?>> RED_MOSS_PATCH_BONEMEAL = register("red_moss_patch_bonemeal", Feature.f_159734_, new VegetationPatchConfiguration(BlockTags.f_144276_, BlockStateProvider.m_191382_(RaspberryBlocks.RED_MOSS.getBlock()), PlacementUtils.m_206506_(RED_MOSS_VEGETATION), CaveSurface.FLOOR, ConstantInt.m_146483_(1), 0.0F, 5, 0.6F, UniformInt.m_146622_(1, 2), 0.75F));


    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<FC, ?>> register(String name, F feature, FC config) {
        return BuiltinRegistries.m_206380_(BuiltinRegistries.f_123861_, "raspberry:"+ name, new ConfiguredFeature(feature, config));
    }

    public static void touch() {

    }
}
