package com.simibubi.create.compat.emi;

import java.util.List;
import java.util.function.BiFunction;

import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import com.simibubi.create.compat.emi.recipes.CreateEmiRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.utility.Lang;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

public abstract class EmiSequencedAssemblySubCategory {
	private final int width;

	public EmiSequencedAssemblySubCategory(int width) {
		this.width = width;
	}

	public int getWidth() {
		return width;
	}

	public abstract void addWidgets(WidgetHolder widgets, int x, int y, SequencedRecipe<?> recipe, int index);

	@Nullable
	public EmiIngredient getAppliedIngredient(SequencedRecipe<?> recipe) {
		return null;
	}

	// TODO tooltips reference first item in an ingredient, EMI has canonical names for tags, use that instead?
	// I tried to implement this and Ingredients not exposing tags is painful
	public static BiFunction<Integer, Integer, List<ClientTooltipComponent>> getTooltip(SequencedRecipe<?> recipe, int index) {
		return (mouseX, mouseY) -> List.of(
			ClientTooltipComponent.m_169948_(Lang.translateDirect("recipe.assembly.step", index + 1).m_7532_()),
			ClientTooltipComponent.m_169948_(recipe.getAsAssemblyRecipe()
				.getDescriptionForAssembly()
				.m_6879_()
				.m_130940_(ChatFormatting.DARK_GREEN).m_7532_())
		);
	}

	public static class AssemblyPressing extends EmiSequencedAssemblySubCategory {

		public AssemblyPressing() {
			super(25);
		}

		@Override
		public void addWidgets(WidgetHolder widgets, int x, int y, SequencedRecipe<?> recipe, int index) {
			widgets.addDrawable(x, y, getWidth(), 96, (matrices, mouseX, mouseY, delta) -> {
				float scale = 0.6f;
				matrices.m_85837_(3, 54, 0);
				matrices.m_85841_(scale, scale, scale);
				CreateEmiAnimations.renderPress(matrices, index, false);
			}).tooltip(getTooltip(recipe, index));
		}
	}

	public static class AssemblySpouting extends EmiSequencedAssemblySubCategory {

		public AssemblySpouting() {
			super(25);
		}

		@Override
		@NotNull
		public EmiIngredient getAppliedIngredient(SequencedRecipe<?> recipe) {
			FluidStack fluid = recipe.getRecipe().getFluidIngredients().get(0).getMatchingFluidStacks().get(0);
			return CreateEmiRecipe.fluidStack(fluid);
		}

		@Override
		public void addWidgets(WidgetHolder widgets, int x, int y, SequencedRecipe<?> recipe, int index) {
			CreateEmiRecipe.addSlot(widgets, getAppliedIngredient(recipe), x + 3, y + 13);
			widgets.addDrawable(x, y, getWidth(), 96, (matrices, mouseX, mouseY, delta) -> {
				float scale = 0.75f;
				matrices.m_85837_(3, 54, 0);
				matrices.m_85841_(scale, scale, scale);
				CreateEmiAnimations.renderSpout(matrices, index, recipe.getRecipe()
					.getFluidIngredients().get(0).getMatchingFluidStacks());
			}).tooltip(getTooltip(recipe, index));
		}
	}

	public static class AssemblyDeploying extends EmiSequencedAssemblySubCategory {

		public AssemblyDeploying() {
			super(25);
		}

		@Override
		@NotNull
		public EmiIngredient getAppliedIngredient(SequencedRecipe<?> recipe) {
			return EmiIngredient.of(recipe.getRecipe().m_7527_().get(1));
		}

		@Override
		public void addWidgets(WidgetHolder widgets, int x, int y, SequencedRecipe<?> recipe, int index) {
			EmiIngredient ingredient = getAppliedIngredient(recipe);
			if (recipe.getAsAssemblyRecipe() instanceof DeployerApplicationRecipe deploy && deploy.shouldKeepHeldItem()) {
				for (EmiStack stack : ingredient.getEmiStacks()) {
					stack.setRemainder(stack);
				}
			}
			CreateEmiRecipe.addSlot(widgets, ingredient, x + 3, y + 13);
			widgets.addDrawable(x, y, getWidth(), 96, (matrices, mouseX, mouseY, delta) -> {
				float scale = 0.75f;
				matrices.m_85837_(3, 54, 0);
				matrices.m_85841_(scale, scale, scale);
				CreateEmiAnimations.renderDeployer(matrices, index);
			}).tooltip(getTooltip(recipe, index));
		}
	}

	public static class AssemblyCutting extends EmiSequencedAssemblySubCategory {

		public AssemblyCutting() {
			super(25);
		}

		@Override
		public void addWidgets(WidgetHolder widgets, int x, int y, SequencedRecipe<?> recipe, int index) {
			widgets.addDrawable(x, y, getWidth(), 96, (matrices, mouseX, mouseY, delta) -> {
				matrices.m_85837_(0, 54.5f, 0);
				float scale = 0.6f;
				matrices.m_85841_(scale, scale, scale);
				matrices.m_85837_(getWidth() / 2, 30, 0);
				CreateEmiAnimations.renderSaw(matrices, index);
			}).tooltip(getTooltip(recipe, index));
		}
	}
}
