package com.simibubi.create.compat.emi.recipes;

import com.simibubi.create.AllItems;
import com.simibubi.create.compat.emi.CreateEmiPlugin;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.element.GuiGameElement;

import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class PolishingEmiRecipe extends CreateEmiRecipe<SandPaperPolishingRecipe> {

	public PolishingEmiRecipe(SandPaperPolishingRecipe recipe) {
		super(CreateEmiPlugin.SANDPAPER_POLISHING, recipe, 134, 55);
	}

	@Override
	public void addWidgets(WidgetHolder widgets) {
		addTexture(widgets, AllGuiTextures.JEI_SHADOW, 39, 25);
		addTexture(widgets, AllGuiTextures.JEI_LONG_ARROW, 30, 37);

		addSlot(widgets, input.get(0), 5, 33);

		addSlot(widgets, output.get(0), 110, 33).recipeContext(this);

		NonNullList<Ingredient> ingredients = recipe.m_7527_();
		if (!ingredients.isEmpty() && !ingredients.get(0).m_43947_()) {
			ItemStack[] matchingStacks = ingredients.get(0).m_43908_();
			ItemStack stack = AllItems.SAND_PAPER.asStack();
			CompoundTag tag = stack.m_41784_();
			tag.m_128365_("Polishing", matchingStacks[0].serializeNBT());
			tag.m_128379_("JEI", true);
			widgets.addDrawable(49, 4, 0, 0, (matrices, mouseX, mouseY, delta) -> {
				matrices.m_85837_(0, 0, 100);
				matrices.m_85841_(2, 2, 1);
				GuiGameElement.of(stack)
						.<GuiGameElement.GuiRenderBuilder>at(0, 0, 1)
						.scale(1)
						.render(matrices);
			});
		}
	}
}
