/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry;

import cc.cassian.raspberry.ModCompat;
import cc.cassian.raspberry.compat.QuarkCompat;
import cc.cassian.raspberry.registry.RaspberrySoundEvents;
import cc.cassian.raspberry.registry.RaspberryTags;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.text.WordUtils;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;

public class ModHelpers {
    public static Component fieldName(Field field) {
        String key = "config.raspberry.config." + field.getName();
        if (I18n.m_118936_((String)key)) {
            return Component.m_237115_((String)key);
        }
        return Component.m_237113_((String)WordUtils.capitalizeFully((String)field.getName()));
    }

    public static <T> T fieldGet(Object instance, Field field) {
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Consumer<T> fieldSetter(Object instance, Field field) {
        return t -> {
            try {
                field.set(instance, t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static char getColour(String colour) {
        String replacedColour;
        int length = colour.length();
        if (length == 1) {
            return colour.charAt(0);
        }
        return switch (replacedColour = colour.toLowerCase().replace(" ", "_")) {
            case "black", "dark_blue", "dark_green", "dark_red", "dark_purple", "blue", "green", "aqua", "red", "yellow", "white" -> Objects.requireNonNullElse(ChatFormatting.m_126657_((String)colour), ChatFormatting.GRAY).m_178510_();
            case "pink", "light_purple" -> Objects.requireNonNullElse(ChatFormatting.m_126657_((String)"light_purple"), ChatFormatting.GRAY).m_178510_();
            case "dark_gray", "dark_grey" -> Objects.requireNonNullElse(ChatFormatting.m_126657_((String)"dark_gray"), ChatFormatting.GRAY).m_178510_();
            case "cyan", "dark_aqua" -> Objects.requireNonNullElse(ChatFormatting.m_126657_((String)"dark_aqua"), ChatFormatting.GRAY).m_178510_();
            case "orange", "gold", "dark_yellow" -> Objects.requireNonNullElse(ChatFormatting.m_126657_((String)"gold"), ChatFormatting.GRAY).m_178510_();
            default -> ChatFormatting.GRAY.m_178510_();
        };
    }

    public static SoundEvent getSoundForItem(ItemStack stack, SoundEvent original) {
        if (stack.m_204117_(RaspberryTags.CRUNCHY_FRUIT_SOUNDS)) {
            return (SoundEvent)RaspberrySoundEvents.CRUNCHY_FRUIT_SOUNDS.get();
        }
        if (stack.m_204117_(RaspberryTags.DRIED_KELP_SOUNDS)) {
            return (SoundEvent)RaspberrySoundEvents.DRIED_KELP_SOUNDS.get();
        }
        if (stack.m_204117_(RaspberryTags.SOFT_FRUIT_SOUNDS)) {
            return (SoundEvent)RaspberrySoundEvents.SOFT_FRUIT_SOUNDS.get();
        }
        if (stack.m_204117_(RaspberryTags.STEW_SOUNDS)) {
            return (SoundEvent)RaspberrySoundEvents.STEW_SOUNDS.get();
        }
        if (stack.m_204117_(RaspberryTags.VEGETABLE_SOUNDS)) {
            return (SoundEvent)RaspberrySoundEvents.VEGETABLE_SOUNDS.get();
        }
        if (stack.m_204117_(RaspberryTags.GENERIC_SOUNDS)) {
            return SoundEvents.f_11912_;
        }
        if (stack.m_204117_(RaspberryTags.DRINK_SOUNDS)) {
            return SoundEvents.f_11911_;
        }
        if (stack.m_204117_(RaspberryTags.HONEY_SOUNDS)) {
            return SoundEvents.f_11970_;
        }
        return original;
    }

    public static boolean shouldWoodPostChainConnect(BlockState downState) {
        if (downState.m_60734_() instanceof CookingPotBlock && ((CookingPotSupport)downState.m_61143_((Property)CookingPotBlock.SUPPORT)).equals((Object)CookingPotSupport.HANDLE)) {
            return true;
        }
        if (downState.m_60734_() instanceof CandleHolderBlock && ((AttachFace)downState.m_61143_((Property)BlockStateProperties.f_61376_)).equals((Object)AttachFace.CEILING)) {
            return true;
        }
        return ModCompat.QUARK && QuarkCompat.isPaperLantern(downState);
    }
}

