/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry;

import cc.cassian.raspberry.ModCompat;
import cc.cassian.raspberry.RaspberryData;
import cc.cassian.raspberry.client.RaspberryModClient;
import cc.cassian.raspberry.compat.AquacultureCompat;
import cc.cassian.raspberry.compat.EnvironmentalCompat;
import cc.cassian.raspberry.compat.NeapolitanCompat;
import cc.cassian.raspberry.compat.QuarkCompat;
import cc.cassian.raspberry.compat.SupplementariesCompat;
import cc.cassian.raspberry.compat.oreganized.OreganizedEvents;
import cc.cassian.raspberry.compat.oreganized.network.RaspberryOreganizedNetwork;
import cc.cassian.raspberry.config.ModConfig;
import cc.cassian.raspberry.entity.SwapArrowEntity;
import cc.cassian.raspberry.events.AftershockEvent;
import cc.cassian.raspberry.events.DarknessRepairEvent;
import cc.cassian.raspberry.network.RaspberryNetwork;
import cc.cassian.raspberry.registry.BlockSupplier;
import cc.cassian.raspberry.registry.RaspberryAttributes;
import cc.cassian.raspberry.registry.RaspberryBlocks;
import cc.cassian.raspberry.registry.RaspberryEntityTypes;
import cc.cassian.raspberry.registry.RaspberryItems;
import cc.cassian.raspberry.registry.RaspberryMobEffects;
import cc.cassian.raspberry.registry.RaspberryParticleTypes;
import cc.cassian.raspberry.registry.RaspberrySoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="raspberry")
public final class RaspberryMod {
    public static final String MOD_ID = "raspberry";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"raspberry");

    public RaspberryMod(FMLJavaModLoadingContext context) {
        IEventBus eventBus = context.getModEventBus();
        ModConfig.load();
        RaspberryNetwork.register();
        RaspberryBlocks.register(eventBus);
        RaspberryItems.ITEMS.register(eventBus);
        RaspberryMobEffects.MOB_EFFECTS.register(eventBus);
        RaspberryEntityTypes.ENTITIES.register(eventBus);
        RaspberrySoundEvents.SOUNDS.register(eventBus);
        RaspberryParticleTypes.PARTICLE_TYPES.register(eventBus);
        MinecraftForge.EVENT_BUS.addListener(this::onItemTooltipEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteract);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinLevel);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingHurt);
        eventBus.addListener(RaspberryMod::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(RaspberryMod::playerTick);
        MinecraftForge.EVENT_BUS.addListener(RaspberryMod::lightningTick);
        if (ModCompat.OREGANIZED) {
            RaspberryAttributes.ATTRIBUTES.register(eventBus);
            RaspberryOreganizedNetwork.register();
            MinecraftForge.EVENT_BUS.addListener(OreganizedEvents::onItemAttributes);
            MinecraftForge.EVENT_BUS.addListener(OreganizedEvents::onHurtEvent);
        }
        if (FMLEnvironment.dist.isClient()) {
            RaspberryModClient.init(context);
        }
        if (ModCompat.BLUEPRINT) {
            RaspberryData.register();
        }
    }

    public static ResourceLocation locate(String id) {
        return RaspberryMod.identifier(MOD_ID, id);
    }

    public static ResourceLocation identifier(String namespace, String id) {
        return new ResourceLocation(namespace, id);
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (ModCompat.NEAPOLITAN) {
            NeapolitanCompat.boostAgility();
        }
        if (ModCompat.QUARK) {
            QuarkCompat.register();
        }
        for (BlockSupplier foliageBlock : RaspberryBlocks.FOLIAGE_BLOCKS) {
            ComposterBlock.f_51914_.put((Object)((ItemLike)foliageBlock.getBlockSupplier().get()), 0.3f);
        }
        if (ModCompat.SUPPLEMENTARIES) {
            SupplementariesCompat.register();
        }
        event.enqueueWork(RaspberryBlocks::addPottedPlants);
    }

    @SubscribeEvent
    public static void lightningTick(EntityStruckByLightningEvent event) {
        if (!ModCompat.COFH_CORE && ModConfig.get().aftershock) {
            AftershockEvent.electrify(event);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        DarknessRepairEvent.tick(event.player);
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        if (ModCompat.AQUACULTURE) {
            AquacultureCompat.checkAndAddTooltip(event);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (ModCompat.ENVIRONMENTAL) {
            EnvironmentalCompat.onEntityInteract(event);
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (ModCompat.ENVIRONMENTAL) {
            EnvironmentalCompat.onEntityJoinWorld(event);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (ModCompat.ENVIRONMENTAL) {
            EnvironmentalCompat.onLivingUpdate(event);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        if (source.m_7640_() instanceof SwapArrowEntity) {
            event.setAmount(0.0f);
        }
    }
}

