/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FineWoodWall
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.f_61378_;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.f_61379_;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.f_61380_;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.f_61381_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final VoxelShape POST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public FineWoodWall(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_(NORTH_WALL, (Comparable)WallSide.NONE)).m_61124_(EAST_WALL, (Comparable)WallSide.NONE)).m_61124_(SOUTH_WALL, (Comparable)WallSide.NONE)).m_61124_(WEST_WALL, (Comparable)WallSide.NONE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes(4.0f, 4.0f, 16.0f, 0.0f, 16.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(4.0f, 4.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape baseShape, WallSide height, VoxelShape lowShape, VoxelShape tallShape) {
        if (height == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)tallShape);
        }
        return height == WallSide.LOW ? Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)lowShape) : baseShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float width, float depth, float wallPostHeight, float wallMinY, float wallLowHeight, float wallTallHeight) {
        float f = 8.0f - width;
        float g = 8.0f + width;
        float h = 8.0f - depth;
        float i = 8.0f + depth;
        VoxelShape voxelShape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)g, (double)wallPostHeight, (double)g);
        VoxelShape voxelShape2 = Block.m_49796_((double)h, (double)wallMinY, (double)0.0, (double)i, (double)wallLowHeight, (double)i);
        VoxelShape voxelShape3 = Block.m_49796_((double)h, (double)wallMinY, (double)h, (double)i, (double)wallLowHeight, (double)16.0);
        VoxelShape voxelShape4 = Block.m_49796_((double)0.0, (double)wallMinY, (double)h, (double)i, (double)wallLowHeight, (double)i);
        VoxelShape voxelShape5 = Block.m_49796_((double)h, (double)wallMinY, (double)h, (double)16.0, (double)wallLowHeight, (double)i);
        VoxelShape voxelShape6 = Block.m_49796_((double)h, (double)wallMinY, (double)0.0, (double)i, (double)wallTallHeight, (double)i);
        VoxelShape voxelShape7 = Block.m_49796_((double)h, (double)wallMinY, (double)h, (double)i, (double)wallTallHeight, (double)16.0);
        VoxelShape voxelShape8 = Block.m_49796_((double)0.0, (double)wallMinY, (double)h, (double)i, (double)wallTallHeight, (double)i);
        VoxelShape voxelShape9 = Block.m_49796_((double)h, (double)wallMinY, (double)h, (double)16.0, (double)wallTallHeight, (double)i);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean boolean_ : UP.m_6908_()) {
            for (WallSide wallSide : EAST_WALL.m_6908_()) {
                for (WallSide wallSide2 : NORTH_WALL.m_6908_()) {
                    for (WallSide wallSide3 : WEST_WALL.m_6908_()) {
                        for (WallSide wallSide4 : SOUTH_WALL.m_6908_()) {
                            VoxelShape voxelShape10 = Shapes.m_83040_();
                            voxelShape10 = FineWoodWall.applyWallShape(voxelShape10, wallSide, voxelShape5, voxelShape9);
                            voxelShape10 = FineWoodWall.applyWallShape(voxelShape10, wallSide3, voxelShape4, voxelShape8);
                            voxelShape10 = FineWoodWall.applyWallShape(voxelShape10, wallSide2, voxelShape2, voxelShape6);
                            voxelShape10 = FineWoodWall.applyWallShape(voxelShape10, wallSide4, voxelShape3, voxelShape7);
                            if (boolean_.booleanValue()) {
                                voxelShape10 = Shapes.m_83110_((VoxelShape)voxelShape10, (VoxelShape)voxelShape);
                            }
                            BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)boolean_)).m_61124_(EAST_WALL, (Comparable)wallSide)).m_61124_(WEST_WALL, (Comparable)wallSide3)).m_61124_(NORTH_WALL, (Comparable)wallSide2)).m_61124_(SOUTH_WALL, (Comparable)wallSide4);
                            builder.put((Object)((BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)voxelShape10);
                            builder.put((Object)((BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)voxelShape10);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeByIndex.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.collisionShapeByIndex.get(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    private boolean connectsTo(BlockState state, boolean sideSolid, Direction direction) {
        Block block = state.m_60734_();
        boolean bl = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return state.m_204336_(BlockTags.f_13032_) || !FineWoodWall.m_152463_((BlockState)state) && sideSolid || block instanceof IronBarsBlock || bl;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelReader = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockPos2 = blockPos.m_122012_();
        BlockPos blockPos3 = blockPos.m_122029_();
        BlockPos blockPos4 = blockPos.m_122019_();
        BlockPos blockPos5 = blockPos.m_122024_();
        BlockPos blockPos6 = blockPos.m_7494_();
        BlockState blockState = levelReader.m_8055_(blockPos2);
        BlockState blockState2 = levelReader.m_8055_(blockPos3);
        BlockState blockState3 = levelReader.m_8055_(blockPos4);
        BlockState blockState4 = levelReader.m_8055_(blockPos5);
        BlockState blockState5 = levelReader.m_8055_(blockPos6);
        boolean bl = this.connectsTo(blockState, blockState.m_60783_((BlockGetter)levelReader, blockPos2, Direction.SOUTH), Direction.SOUTH);
        boolean bl2 = this.connectsTo(blockState2, blockState2.m_60783_((BlockGetter)levelReader, blockPos3, Direction.WEST), Direction.WEST);
        boolean bl3 = this.connectsTo(blockState3, blockState3.m_60783_((BlockGetter)levelReader, blockPos4, Direction.NORTH), Direction.NORTH);
        boolean bl4 = this.connectsTo(blockState4, blockState4.m_60783_((BlockGetter)levelReader, blockPos5, Direction.EAST), Direction.EAST);
        BlockState blockState6 = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return this.updateShape((LevelReader)levelReader, blockState6, blockPos6, blockState5, bl, bl2, bl3, bl4);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction == Direction.DOWN) {
            return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        }
        return direction == Direction.UP ? this.topUpdate((LevelReader)level, state, neighborPos, neighborState) : this.sideUpdate((LevelReader)level, currentPos, state, neighborPos, neighborState, direction);
    }

    private static boolean isConnected(BlockState state, Property<WallSide> heightProperty) {
        return state.m_61143_(heightProperty) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape firstShape, VoxelShape secondShape) {
        return !Shapes.m_83157_((VoxelShape)secondShape, (VoxelShape)firstShape, (BooleanOp)BooleanOp.f_82685_);
    }

    private BlockState topUpdate(LevelReader level, BlockState state, BlockPos pos, BlockState secondState) {
        boolean bl = FineWoodWall.isConnected(state, NORTH_WALL);
        boolean bl2 = FineWoodWall.isConnected(state, EAST_WALL);
        boolean bl3 = FineWoodWall.isConnected(state, SOUTH_WALL);
        boolean bl4 = FineWoodWall.isConnected(state, WEST_WALL);
        return this.updateShape(level, state, pos, secondState, bl, bl2, bl3, bl4);
    }

    private BlockState sideUpdate(LevelReader level, BlockPos firstPos, BlockState firstState, BlockPos secondPos, BlockState secondState, Direction dir) {
        Direction direction = dir.m_122424_();
        boolean bl = dir == Direction.NORTH ? this.connectsTo(secondState, secondState.m_60783_((BlockGetter)level, secondPos, direction), direction) : FineWoodWall.isConnected(firstState, NORTH_WALL);
        boolean bl2 = dir == Direction.EAST ? this.connectsTo(secondState, secondState.m_60783_((BlockGetter)level, secondPos, direction), direction) : FineWoodWall.isConnected(firstState, EAST_WALL);
        boolean bl3 = dir == Direction.SOUTH ? this.connectsTo(secondState, secondState.m_60783_((BlockGetter)level, secondPos, direction), direction) : FineWoodWall.isConnected(firstState, SOUTH_WALL);
        boolean bl4 = dir == Direction.WEST ? this.connectsTo(secondState, secondState.m_60783_((BlockGetter)level, secondPos, direction), direction) : FineWoodWall.isConnected(firstState, WEST_WALL);
        BlockPos blockPos = firstPos.m_7494_();
        BlockState blockState = level.m_8055_(blockPos);
        return this.updateShape(level, firstState, blockPos, blockState, bl, bl2, bl3, bl4);
    }

    private BlockState updateShape(LevelReader level, BlockState state, BlockPos pos, BlockState neighbour, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection) {
        VoxelShape voxelShape = neighbour.m_60812_((BlockGetter)level, pos).m_83263_(Direction.DOWN);
        BlockState blockState = this.updateSides(state, northConnection, eastConnection, southConnection, westConnection, voxelShape);
        return (BlockState)blockState.m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.shouldRaisePost(blockState, neighbour, voxelShape)));
    }

    private boolean shouldRaisePost(BlockState state, BlockState neighbour, VoxelShape shape) {
        boolean bl7;
        boolean bl6;
        boolean bl;
        boolean bl2 = bl = neighbour.m_60734_() instanceof WallBlock && (Boolean)neighbour.m_61143_((Property)UP) != false;
        if (bl) {
            return true;
        }
        WallSide wallSide = (WallSide)state.m_61143_(NORTH_WALL);
        WallSide wallSide2 = (WallSide)state.m_61143_(SOUTH_WALL);
        WallSide wallSide3 = (WallSide)state.m_61143_(EAST_WALL);
        WallSide wallSide4 = (WallSide)state.m_61143_(WEST_WALL);
        boolean bl22 = wallSide2 == WallSide.NONE;
        boolean bl3 = wallSide4 == WallSide.NONE;
        boolean bl4 = wallSide3 == WallSide.NONE;
        boolean bl5 = wallSide == WallSide.NONE;
        boolean bl8 = bl6 = bl5 && bl22 && bl3 && bl4 || bl5 != bl22 || bl3 != bl4;
        if (bl6) {
            return true;
        }
        boolean bl9 = bl7 = wallSide == WallSide.TALL && wallSide2 == WallSide.TALL || wallSide3 == WallSide.TALL && wallSide4 == WallSide.TALL;
        if (bl7) {
            return false;
        }
        return neighbour.m_204336_(BlockTags.f_13081_) || FineWoodWall.isCovered(shape, POST_TEST);
    }

    private BlockState updateSides(BlockState state, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection, VoxelShape wallShape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)this.makeWallState(northConnection, wallShape, NORTH_TEST))).m_61124_(EAST_WALL, (Comparable)this.makeWallState(eastConnection, wallShape, EAST_TEST))).m_61124_(SOUTH_WALL, (Comparable)this.makeWallState(southConnection, wallShape, SOUTH_TEST))).m_61124_(WEST_WALL, (Comparable)this.makeWallState(westConnection, wallShape, WEST_TEST));
    }

    private WallSide makeWallState(boolean allowConnection, VoxelShape shape, VoxelShape neighbourShape) {
        if (allowConnection) {
            return FineWoodWall.isCovered(shape, neighbourShape) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)((WallSide)state.m_61143_(SOUTH_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)state.m_61143_(WEST_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)state.m_61143_(NORTH_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)state.m_61143_(EAST_WALL)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)((WallSide)state.m_61143_(EAST_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)state.m_61143_(SOUTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)state.m_61143_(WEST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)state.m_61143_(NORTH_WALL)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)((WallSide)state.m_61143_(WEST_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)state.m_61143_(NORTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)state.m_61143_(EAST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)state.m_61143_(SOUTH_WALL)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)((WallSide)state.m_61143_(SOUTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)state.m_61143_(NORTH_WALL)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_(EAST_WALL, (Comparable)((WallSide)state.m_61143_(WEST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)state.m_61143_(EAST_WALL)));
            }
        }
        return super.m_6943_(state, mirror);
    }
}

