/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.client.music;

import cc.cassian.raspberry.RaspberryMod;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.RecordItem;

public class MusicHandler
implements ResourceManagerReloadListener {
    private static final Map<ResourceLocation, MusicMetadata> MUSIC_DB = new HashMap<ResourceLocation, MusicMetadata>();
    private static final ResourceLocation DATA_LOCATION = new ResourceLocation("raspberry", "musics.json");

    public void m_6213_(ResourceManager resourceManager) {
        MUSIC_DB.clear();
        List resources = resourceManager.m_213829_(DATA_LOCATION);
        for (Resource resource : resources) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8));){
                JsonObject json = GsonHelper.m_13859_((Reader)reader);
                for (Map.Entry entry : json.entrySet()) {
                    ResourceLocation id = new ResourceLocation((String)entry.getKey());
                    JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                    String title = GsonHelper.m_13851_((JsonObject)data, (String)"title", (String)"Unknown");
                    String author = GsonHelper.m_13851_((JsonObject)data, (String)"author", (String)"");
                    MUSIC_DB.put(id, new MusicMetadata((Component)Component.m_237113_((String)title), (Component)Component.m_237113_((String)author)));
                }
            }
            catch (IOException | RuntimeException e) {
                RaspberryMod.LOGGER.error("Failed to load music data from {}", (Object)resource.m_215506_(), (Object)e);
            }
        }
    }

    public static MusicMetadata getMusicInfo(ResourceLocation location) {
        if (MUSIC_DB.containsKey(location)) {
            return MUSIC_DB.get(location);
        }
        String path = location.m_135815_();
        if (path.contains("/")) {
            path = path.substring(path.lastIndexOf(47) + 1);
        }
        if (path.contains(".")) {
            path = path.substring(0, path.lastIndexOf(46));
        }
        return new MusicMetadata((Component)Component.m_237113_((String)MusicHandler.beautifyName(path)), (Component)Component.m_237119_());
    }

    public static MusicMetadata getDiscInfo(RecordItem disc) {
        String descKey = disc.m_5524_() + ".desc";
        String fullDescription = Component.m_237115_((String)descKey).getString();
        String[] split = fullDescription.split(" - ");
        if (split.length >= 2) {
            return new MusicMetadata((Component)Component.m_237113_((String)split[1]), (Component)Component.m_237113_((String)split[0]));
        }
        return new MusicMetadata(disc.m_41466_(), (Component)Component.m_237119_());
    }

    private static String beautifyName(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String[] words = input.split("[_.\\s]+");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            sb.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() > 1) {
                sb.append(word.substring(1));
            }
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public record MusicMetadata(Component title, Component author) {
    }
}

