/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.emi;

import cc.cassian.raspberry.compat.BrewinAndChewinCompat;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.client.recipebook.KegRecipeBookTab;

public class EmiFermentingRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final String group;
    private final KegRecipeBookTab tab;
    private final NonNullList<EmiIngredient> inputItems;
    private final Ingredient fluidItem;
    private final ItemStack output;
    private final ItemStack container;
    private final float experience;
    private final int fermentTime;
    private final int temperature;

    public EmiFermentingRecipe(ResourceLocation id, String group, @javax.annotation.Nullable KegRecipeBookTab tab, NonNullList<Ingredient> inputItems, Ingredient fluidItem, ItemStack output, ItemStack container, float experience, int fermentTime, int temperature) {
        this.id = id;
        this.group = group;
        this.tab = tab;
        NonNullList ingredients = NonNullList.m_122779_();
        for (Ingredient inputItem : inputItems) {
            ingredients.add((Object)EmiIngredient.of((Ingredient)inputItem));
        }
        this.inputItems = ingredients;
        this.fluidItem = fluidItem;
        this.output = output;
        this.container = !container.m_41619_() ? container : (!output.getCraftingRemainingItem().m_41619_() ? output.getCraftingRemainingItem() : ItemStack.f_41583_);
        this.experience = experience;
        this.fermentTime = fermentTime;
        this.temperature = temperature;
    }

    public EmiRecipeCategory getCategory() {
        return BrewinAndChewinCompat.FERMENTING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputItems;
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemStack)this.output));
    }

    public int getDisplayWidth() {
        return 117;
    }

    public int getDisplayHeight() {
        return 57;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        ResourceLocation backgroundImage = new ResourceLocation("brewinandchewin", "textures/gui/jei/keg.png");
        widgetHolder.addTexture(backgroundImage, 0, 0, 117, 57, 29, 16);
        widgetHolder.addAnimatedTexture(backgroundImage, 48, 28, 33, 9, 176, 28, this.fermentTime * 20, true, false, false).tooltipText(this.addFermentingTime(this.fermentTime / 1200));
        if (this.temperature == 1) {
            widgetHolder.addTexture(backgroundImage, 47, 23, 7, 3, 176, 0).tooltipText(List.of(Component.m_237115_((String)"emi.brewinandchewin.fermenting.frigid")));
            widgetHolder.addTexture(backgroundImage, 54, 23, 7, 3, 182, 0).tooltipText(List.of(Component.m_237115_((String)"emi.brewinandchewin.fermenting.frigid")));
        }
        if (this.temperature == 2) {
            widgetHolder.addTexture(backgroundImage, 54, 23, 7, 3, 182, 0).tooltipText(List.of(Component.m_237115_((String)"emi.brewinandchewin.fermenting.cold")));
        }
        if (this.temperature == 4) {
            widgetHolder.addTexture(backgroundImage, 67, 23, 7, 3, 195, 0).tooltipText(List.of(Component.m_237115_((String)"emi.brewinandchewin.fermenting.warm")));
        }
        if (this.temperature == 5) {
            widgetHolder.addTexture(backgroundImage, 74, 23, 7, 3, 202, 0).tooltipText(List.of(Component.m_237115_((String)"emi.brewinandchewin.fermenting.hot")));
            widgetHolder.addTexture(backgroundImage, 67, 23, 7, 3, 195, 0).tooltipText(List.of(Component.m_237115_((String)"emi.brewinandchewin.fermenting.hot")));
        }
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int inputIndex = row * 2 + column;
                try {
                    widgetHolder.addSlot((EmiIngredient)this.inputItems.get(inputIndex), column * borderSlotSize + 3, row * borderSlotSize + 11);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!this.fluidItem.m_43947_()) {
            widgetHolder.addSlot(EmiIngredient.of((Ingredient)this.fluidItem), 55, 1);
        }
        widgetHolder.addSlot(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.output})), 92, 7).drawBack(false).recipeContext((EmiRecipe)this);
        if (!this.container.m_41619_()) {
            widgetHolder.addSlot(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.container})), 60, 38);
        }
        widgetHolder.addSlot(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.output})), 92, 38);
    }

    private List<Component> addFermentingTime(int i) {
        if (i == 1) {
            return Collections.singletonList(Component.m_237110_((String)"emi.cooking.time_minute", (Object[])new Object[]{i}));
        }
        return Collections.singletonList(Component.m_237110_((String)"emi.cooking.time_minutes", (Object[])new Object[]{i}));
    }
}

