/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.supplementaries;

import cc.cassian.raspberry.config.ModConfig;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RoseGoldBombExplosion
extends BombExplosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    private final float radius;

    public RoseGoldBombExplosion(Level world, @Nullable Entity entity, @Nullable ExplosionDamageCalculator context, double x, double y, double z, float radius, BombEntity.BombType bombType, Explosion.BlockInteraction interaction) {
        super(world, entity, context, x, y, z, radius, bombType, interaction);
        this.level = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
    }

    public void m_46061_() {
        Player pl;
        Projectile pr;
        this.level.m_142346_(this.getExploder(), GameEvent.f_157812_, new BlockPos(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        Entity var5 = this.getExploder();
        Player var10000 = var5 instanceof Projectile && (var5 = (pr = (Projectile)var5).m_37282_()) instanceof Player ? (pl = (Player)var5) : null;
        Player owner = var10000;
        this.getToBlow().addAll((Collection)set);
        float diameter = this.radius * 2.0f;
        int k1 = Mth.m_14107_((double)(this.x - (double)diameter - 1.0));
        int l1 = Mth.m_14107_((double)(this.x + (double)diameter + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)diameter - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)diameter + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)diameter - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)diameter + 1.0));
        List list = this.level.m_45933_(this.getExploder(), new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeHelper.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)diameter);
        Vec3 vector3d = new Vec3(this.x, this.y, this.z);
        for (Entity entity : list) {
            double knockbackBeforeEnchantments;
            double dz;
            double dy;
            double dx;
            double distFromCenterSqr;
            double distSq;
            double normalizedDist;
            if (entity.m_6128_() || owner != null && CompatHandler.FLAN && !FlanCompat.canAttack((Player)owner, (Entity)entity) || !((normalizedDist = (double)(Mth.m_14116_((float)((float)(distSq = entity.m_20238_(vector3d)))) / diameter)) <= 1.0) || (distFromCenterSqr = (double)Mth.m_14116_((float)((float)((dx = entity.m_20185_() - this.x) * dx + (dy = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * dy + (dz = entity.m_20189_() - this.z) * dz)))) == 0.0) continue;
            dx /= distFromCenterSqr;
            dy /= distFromCenterSqr;
            dz /= distFromCenterSqr;
            double visiblePercent = RoseGoldBombExplosion.m_46064_((Vec3)vector3d, (Entity)entity);
            double knockback = knockbackBeforeEnchantments = (1.0 - normalizedDist) * visiblePercent * ModConfig.get().rose_gold_bomb_knockback;
            boolean isPlayer = entity instanceof Player;
            Player playerEntity = null;
            if (!(!isPlayer || (playerEntity = (Player)entity).m_5833_() || playerEntity.m_7500_() && playerEntity.m_150110_().f_35935_)) {
                this.m_46078_().put(playerEntity, new Vec3(dx * knockbackBeforeEnchantments, dy * knockbackBeforeEnchantments, dz * knockbackBeforeEnchantments));
            }
            if (entity instanceof LivingEntity) {
                knockback = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)knockbackBeforeEnchantments);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(dx * knockback, dy * knockback, dz * knockback));
        }
        if (!this.level.f_46443_) {
            for (Map.Entry entry : this.m_46078_().entrySet()) {
                NetworkHandler.CHANNEL.sendToClientPlayer((ServerPlayer)entry.getKey(), (Message)new ClientBoundSendKnockbackPacket((Vec3)entry.getValue(), ((Player)entry.getKey()).m_19879_()));
            }
        }
    }

    public static class RoseGoldBombExplosionDamageCalculator
    extends ExplosionDamageCalculator {
        public boolean m_6714_(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
            return false;
        }
    }
}

