/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.vanillabackport.leash;

import cc.cassian.raspberry.mixin.minecraft.EntityAccessor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class InterpolationHandler {
    private final Entity entity;
    private final int interpolationSteps;
    private final InterpolationData data = new InterpolationData(0, Vec3.f_82478_, 0.0f, 0.0f);
    @Nullable
    private Vec3 previousTickPosition;
    @Nullable
    private Vec2 previousTickRot;

    public InterpolationHandler(Entity entity, int steps) {
        this.interpolationSteps = steps;
        this.entity = entity;
    }

    public void interpolateTo(Vec3 position, float y, float x) {
        if (this.interpolationSteps == 0) {
            this.entity.m_20343_(position.f_82479_, position.f_82480_, position.f_82481_);
            this.entity.m_146922_(y);
            this.entity.m_146926_(x);
            this.entity.m_146867_();
            ((EntityAccessor)this.entity).callReapplyPosition();
            this.cancel();
        } else {
            this.data.steps = this.interpolationSteps;
            this.data.position = position;
            this.data.yRot = y;
            this.data.xRot = x;
            this.previousTickPosition = this.entity.m_20182_();
            this.previousTickRot = new Vec2(this.entity.m_146909_(), this.entity.m_146908_());
        }
    }

    public boolean hasActiveInterpolation() {
        return this.data.steps > 0;
    }

    public void interpolate() {
        if (!this.hasActiveInterpolation()) {
            this.cancel();
        } else {
            double progress = 1.0 / (double)this.data.steps;
            if (this.previousTickPosition != null) {
                Vec3 movement = this.entity.m_20182_().m_82546_(this.previousTickPosition);
                if (this.entity.f_19853_.m_45756_(this.entity, ((EntityAccessor)this.entity).getDimensions().m_20393_(this.data.position.m_82549_(movement)))) {
                    this.data.addDelta(movement);
                }
            }
            if (this.previousTickRot != null) {
                float yRot = this.entity.m_146908_() - this.previousTickRot.f_82471_;
                float xRot = this.entity.m_146909_() - this.previousTickRot.f_82470_;
                this.data.addRotation(yRot, xRot);
            }
            double x = Mth.m_14139_((double)progress, (double)this.entity.m_20185_(), (double)this.data.position.f_82479_);
            double y = Mth.m_14139_((double)progress, (double)this.entity.m_20186_(), (double)this.data.position.f_82480_);
            double z = Mth.m_14139_((double)progress, (double)this.entity.m_20189_(), (double)this.data.position.f_82481_);
            Vec3 position = new Vec3(x, y, z);
            float yRot = Mth.m_14189_((float)((float)progress), (float)this.entity.m_146908_(), (float)this.data.yRot);
            float xRot = (float)Mth.m_14139_((double)progress, (double)this.entity.m_146909_(), (double)this.data.xRot);
            this.entity.m_146884_(position);
            ((EntityAccessor)this.entity).callSetRot(yRot, xRot);
            this.data.decrease();
            this.previousTickPosition = position;
            this.previousTickRot = new Vec2(this.entity.m_146909_(), this.entity.m_146908_());
        }
    }

    public void cancel() {
        this.data.steps = 0;
        this.previousTickPosition = null;
        this.previousTickRot = null;
    }

    static class InterpolationData {
        protected int steps;
        Vec3 position;
        float yRot;
        float xRot;

        InterpolationData(int steps, Vec3 position, float yRot, float xRot) {
            this.steps = steps;
            this.position = position;
            this.yRot = yRot;
            this.xRot = xRot;
        }

        public void decrease() {
            --this.steps;
        }

        public void addDelta(Vec3 vec3) {
            this.position = this.position.m_82549_(vec3);
        }

        public void addRotation(float yRot, float xRot) {
            this.yRot += yRot;
            this.xRot += xRot;
        }
    }
}

