/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.vanillabackport.leash;

import cc.cassian.raspberry.compat.vanillabackport.leash.KnotConnectionAccess;
import cc.cassian.raspberry.compat.vanillabackport.leash.KnotInteractionHelper;
import cc.cassian.raspberry.compat.vanillabackport.leash.Leashable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class KnotConnectionManager {
    private static final String CONNECTIONS_NBT_KEY = "KnotConnections";
    private final Set<UUID> connectedKnotUuids = new HashSet<UUID>();

    public void checkDistance(LeashFenceKnotEntity self) {
        if (self.f_19853_.f_46443_) {
            return;
        }
        List<LeashFenceKnotEntity> knots = this.getConnectedKnots(self);
        boolean snappedAny = false;
        for (LeashFenceKnotEntity knot : knots) {
            double d = self.m_20270_((Entity)knot);
            if (!(d > 12.0)) continue;
            snappedAny = true;
            KnotConnectionManager.removeConnection(self, knot);
            self.m_19998_((ItemLike)Items.f_42655_);
            KnotInteractionHelper.syncKnots(knot);
        }
        if (snappedAny) {
            KnotInteractionHelper.syncKnots(self);
        }
    }

    public static boolean createConnection(LeashFenceKnotEntity knotA, LeashFenceKnotEntity knotB) {
        if (knotA == knotB) {
            return false;
        }
        KnotConnectionManager managerA = KnotConnectionManager.getManager(knotA);
        KnotConnectionManager managerB = KnotConnectionManager.getManager(knotB);
        boolean addedA = managerA.connectedKnotUuids.add(knotB.m_20148_());
        boolean addedB = managerB.connectedKnotUuids.add(knotA.m_20148_());
        if (addedA || addedB) {
            KnotInteractionHelper.syncKnots(knotA);
            KnotInteractionHelper.syncKnots(knotB);
        }
        return addedA || addedB;
    }

    public static void removeConnection(LeashFenceKnotEntity knotA, LeashFenceKnotEntity knotB) {
        if (knotA == knotB) {
            return;
        }
        KnotConnectionManager managerA = KnotConnectionManager.getManager(knotA);
        KnotConnectionManager managerB = KnotConnectionManager.getManager(knotB);
        managerA.connectedKnotUuids.remove(knotB.m_20148_());
        managerB.connectedKnotUuids.remove(knotA.m_20148_());
        KnotInteractionHelper.syncKnots(knotA);
        KnotInteractionHelper.syncKnots(knotB);
    }

    public List<LeashFenceKnotEntity> getConnectedKnots(LeashFenceKnotEntity self) {
        ArrayList<LeashFenceKnotEntity> connectedKnots = new ArrayList<LeashFenceKnotEntity>();
        Level level = self.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Iterator<UUID> iterator = this.connectedKnotUuids.iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                Entity entity = serverLevel.m_8791_(uuid);
                if (!(entity instanceof LeashFenceKnotEntity)) continue;
                LeashFenceKnotEntity knot = (LeashFenceKnotEntity)entity;
                if (!knot.m_213877_()) {
                    connectedKnots.add(knot);
                    continue;
                }
                iterator.remove();
            }
        } else {
            for (UUID uuid : this.connectedKnotUuids) {
                List entities = level.m_6443_(LeashFenceKnotEntity.class, new AABB(self.m_20183_()).m_82400_(50.0), e -> e.m_20148_().equals(uuid));
                if (entities.isEmpty()) continue;
                connectedKnots.add((LeashFenceKnotEntity)entities.get(0));
            }
        }
        return connectedKnots;
    }

    public Set<UUID> getConnectedUuids() {
        return new HashSet<UUID>(this.connectedKnotUuids);
    }

    public void setConnectedUuids(Set<UUID> uuids) {
        this.connectedKnotUuids.clear();
        this.connectedKnotUuids.addAll(uuids);
    }

    public boolean hasConnections() {
        return !this.connectedKnotUuids.isEmpty();
    }

    public void clearAllConnections(Level level, LeashFenceKnotEntity self) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (UUID uuid : new ArrayList<UUID>(this.connectedKnotUuids)) {
            Leashable leashable;
            Entity entity = serverLevel.m_8791_(uuid);
            self.m_19998_((ItemLike)Items.f_42655_);
            if (!(entity instanceof LeashFenceKnotEntity)) continue;
            LeashFenceKnotEntity knot = (LeashFenceKnotEntity)entity;
            KnotConnectionManager.getManager((LeashFenceKnotEntity)knot).connectedKnotUuids.remove(self.m_20148_());
            KnotInteractionHelper.syncKnots(knot);
            boolean hasVanilla = !Leashable.leashableLeashedTo((Entity)knot).isEmpty();
            boolean isBeingLeashed = knot instanceof Leashable && (leashable = (Leashable)knot).raspberry$getLeashHolder() != null;
            boolean hasCustom = KnotConnectionManager.getManager(knot).hasConnections();
            if (hasVanilla || isBeingLeashed || hasCustom) continue;
            knot.m_146870_();
        }
        this.connectedKnotUuids.clear();
        KnotInteractionHelper.syncKnots(self);
    }

    public void writeToNbt(CompoundTag tag) {
        if (!this.connectedKnotUuids.isEmpty()) {
            ListTag list = new ListTag();
            for (UUID uuid : this.connectedKnotUuids) {
                list.add((Object)NbtUtils.m_129226_((UUID)uuid));
            }
            tag.m_128365_(CONNECTIONS_NBT_KEY, (Tag)list);
        }
    }

    public void readFromNbt(CompoundTag tag) {
        this.connectedKnotUuids.clear();
        if (tag.m_128441_(CONNECTIONS_NBT_KEY)) {
            ListTag list = tag.m_128437_(CONNECTIONS_NBT_KEY, 11);
            for (Tag value : list) {
                this.connectedKnotUuids.add(NbtUtils.m_129233_((Tag)value));
            }
        }
    }

    public static KnotConnectionManager getManager(LeashFenceKnotEntity knot) {
        return ((KnotConnectionAccess)knot).raspberry$getConnectionManager();
    }
}

