/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.vanillabackport.leash;

import cc.cassian.raspberry.compat.vanillabackport.leash.KnotConnectionManager;
import cc.cassian.raspberry.compat.vanillabackport.leash.Leashable;
import cc.cassian.raspberry.compat.vanillabackport.leash.network.KnotConnectionSyncPacket;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class KnotInteractionHelper {
    public static void syncKnots(LeashFenceKnotEntity knot) {
        if (knot.f_19853_.f_46443_) {
            return;
        }
        KnotConnectionManager manager = KnotConnectionManager.getManager(knot);
        KnotConnectionSyncPacket packet = new KnotConnectionSyncPacket(knot.m_19879_(), manager.getConnectedUuids());
        Level level = knot.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(knot.m_20183_()), false)) {
                packet.sendTo(player);
            }
        }
    }

    public static InteractionResult handleKnotInteraction(Player player, InteractionHand hand, LeashFenceKnotEntity knot) {
        HeldEntities held = new HeldEntities((Entity)player);
        boolean isHoldingThisKnot = held.all.stream().anyMatch(l -> l == knot);
        if (!(held.isEmpty() || held.all.size() == 1 && isHoldingThisKnot)) {
            boolean created = false;
            for (LeashFenceKnotEntity heldKnot : held.knots) {
                if (heldKnot == knot || (double)heldKnot.m_20270_((Entity)knot) > 12.0 || !KnotConnectionManager.createConnection(heldKnot, knot)) continue;
                created = true;
                ((Leashable)heldKnot).raspberry$dropLeash(true, false);
                KnotInteractionHelper.syncKnots(heldKnot);
            }
            for (Leashable mob : held.mobs) {
                if (((Leashable)knot).raspberry$getLeashHolder() == mob) continue;
                mob.raspberry$setLeashedTo((Entity)knot, true);
                created = true;
            }
            if (created) {
                KnotInteractionHelper.syncKnots(knot);
                knot.m_5496_(SoundEvents.f_12087_, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        HeldEntities heldByKnot = new HeldEntities((Entity)knot);
        boolean isKnotLeashed = ((Leashable)knot).raspberry$isLeashed();
        boolean hasCustom = KnotConnectionManager.getManager(knot).hasConnections();
        boolean isShears = player.m_21120_(hand).m_41720_() instanceof ShearsItem;
        if ((player.m_6144_() || isShears) && (heldByKnot.hasMobs || hasCustom || isKnotLeashed)) {
            knot.m_5496_(SoundEvents.f_12033_, 1.0f, 1.0f);
            for (Leashable mob : heldByKnot.mobs) {
                mob.raspberry$dropLeash(true, false);
                if (player.m_150110_().f_35937_ || !(mob instanceof Entity)) continue;
                Entity entity = (Entity)mob;
                entity.m_19998_((ItemLike)Items.f_42655_);
            }
            if (hasCustom) {
                KnotInteractionHelper.discardCustomConnections(knot, (Entity)player);
            }
            if (isKnotLeashed) {
                ((Leashable)knot).raspberry$dropLeash(true, true);
            }
            knot.m_146870_();
            return InteractionResult.SUCCESS;
        }
        if (heldByKnot.hasMobs) {
            for (Leashable mob : heldByKnot.mobs) {
                mob.raspberry$setLeashedTo((Entity)player, true);
            }
            knot.m_5496_(SoundEvents.f_12033_, 1.0f, 1.0f);
            if (KnotInteractionHelper.shouldRemoveKnot(knot)) {
                knot.m_146870_();
            }
            return InteractionResult.SUCCESS;
        }
        if (isHoldingThisKnot) {
            ((Leashable)knot).raspberry$dropLeash(true, true);
            return InteractionResult.SUCCESS;
        }
        if (isKnotLeashed) {
            ((Leashable)knot).raspberry$setLeashedTo((Entity)player, true);
            knot.m_5496_(SoundEvents.f_12033_, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (KnotInteractionHelper.hasLeadItem(player)) {
            ((Leashable)knot).raspberry$setLeashedTo((Entity)player, true);
            knot.m_5496_(SoundEvents.f_12087_, 1.0f, 1.0f);
            KnotInteractionHelper.consumeLead(player);
            return InteractionResult.SUCCESS;
        }
        if (hasCustom) {
            KnotInteractionHelper.pickupCustomConnections(knot, player);
            knot.m_5496_(SoundEvents.f_12033_, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean hasLeadItem(Player player) {
        return player.m_21205_().m_41720_() instanceof LeadItem || player.m_21206_().m_41720_() instanceof LeadItem;
    }

    public static void consumeLead(Player player) {
        if (!player.m_150110_().f_35937_) {
            if (player.m_21205_().m_41720_() instanceof LeadItem) {
                player.m_21205_().m_41774_(1);
            } else if (player.m_21206_().m_41720_() instanceof LeadItem) {
                player.m_21206_().m_41774_(1);
            }
        }
    }

    public static boolean shouldRemoveKnot(LeashFenceKnotEntity knot) {
        boolean hasVanilla = !Leashable.leashableLeashedTo((Entity)knot).isEmpty();
        boolean isLeashed = ((Leashable)knot).raspberry$getLeashHolder() != null;
        boolean hasCustom = KnotConnectionManager.getManager(knot).hasConnections();
        return !hasVanilla && !isLeashed && !hasCustom;
    }

    public static void pickupCustomConnections(LeashFenceKnotEntity knot, Player player) {
        KnotConnectionManager manager = KnotConnectionManager.getManager(knot);
        List<LeashFenceKnotEntity> connected = manager.getConnectedKnots(knot);
        Iterator<LeashFenceKnotEntity> iterator = connected.iterator();
        if (iterator.hasNext()) {
            LeashFenceKnotEntity other = iterator.next();
            KnotConnectionManager.removeConnection(knot, other);
            if (player.m_20280_((Entity)other) <= 100.0) {
                ((Leashable)other).raspberry$setLeashedTo((Entity)player, true);
                KnotInteractionHelper.syncKnots(other);
            } else {
                other.m_19998_((ItemLike)Items.f_42655_);
                if (KnotInteractionHelper.shouldRemoveKnot(other)) {
                    other.m_146870_();
                } else {
                    KnotInteractionHelper.syncKnots(other);
                }
            }
        }
        if (KnotInteractionHelper.shouldRemoveKnot(knot)) {
            knot.m_146870_();
        } else {
            KnotInteractionHelper.syncKnots(knot);
        }
    }

    public static void discardCustomConnections(LeashFenceKnotEntity knot, Entity breaker) {
        KnotConnectionManager manager = KnotConnectionManager.getManager(knot);
        List<LeashFenceKnotEntity> connected = manager.getConnectedKnots(knot);
        for (LeashFenceKnotEntity other : connected) {
            KnotConnectionManager.removeConnection(knot, other);
            if (KnotInteractionHelper.shouldRemoveKnot(other)) {
                other.m_146870_();
            } else {
                KnotInteractionHelper.syncKnots(other);
            }
            knot.m_19998_((ItemLike)Items.f_42655_);
        }
        if (KnotInteractionHelper.shouldRemoveKnot(knot)) {
            knot.m_146870_();
        } else {
            KnotInteractionHelper.syncKnots(knot);
        }
        knot.m_146852_(GameEvent.f_157795_, breaker);
    }

    public static class HeldEntities {
        public final List<Leashable> all;
        public final List<Leashable> mobs;
        public final List<LeashFenceKnotEntity> knots;
        public final boolean hasMobs;
        public final boolean hasKnots;

        public HeldEntities(Entity holder) {
            this.all = Leashable.leashableInArea(holder.f_19853_, holder.m_20182_(), l -> l.raspberry$getLeashHolder() == holder);
            this.mobs = this.all.stream().filter(l -> !(l instanceof LeashFenceKnotEntity)).toList();
            this.knots = this.all.stream().filter(l -> l instanceof LeashFenceKnotEntity).map(l -> (LeashFenceKnotEntity)l).toList();
            this.hasMobs = !this.mobs.isEmpty();
            this.hasKnots = !this.knots.isEmpty();
        }

        public boolean isEmpty() {
            return this.all.isEmpty();
        }
    }
}

