/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.vanillabackport.leash;

import cc.cassian.raspberry.compat.vanillabackport.leash.KnotConnectionAccess;
import cc.cassian.raspberry.compat.vanillabackport.leash.KnotConnectionManager;
import cc.cassian.raspberry.compat.vanillabackport.leash.KnotInteractionHelper;
import cc.cassian.raspberry.compat.vanillabackport.leash.Leashable;
import cc.cassian.raspberry.compat.vanillabackport.leash.network.KnotConnectionSyncPacket;
import cc.cassian.raspberry.config.ModConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="raspberry")
public class LeashEvents {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        List<Leashable> nearbyEntities;
        LivingEntity living;
        Leashable leashable;
        if (!ModConfig.get().backportLeash) {
            return;
        }
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack stack = event.getItemStack();
        if (!target.f_19853_.f_46443_ && player.m_36341_() && target instanceof Leashable && (leashable = (Leashable)target).canBeLeashed(player) && target.m_6084_() && (!(target instanceof LivingEntity) || !(living = (LivingEntity)target).m_6162_()) && !(nearbyEntities = Leashable.leashableInArea(target.f_19853_, target.m_20182_(), l -> l.raspberry$getLeashHolder() == player)).isEmpty()) {
            boolean attachedAny = false;
            for (Leashable sourceEntity : nearbyEntities) {
                if (sourceEntity instanceof LeashFenceKnotEntity && target instanceof LeashFenceKnotEntity || sourceEntity instanceof LeashFenceKnotEntity || target instanceof LeashFenceKnotEntity || leashable.raspberry$getLeashHolder() == sourceEntity || !sourceEntity.canHaveALeashAttachedTo(target)) continue;
                sourceEntity.raspberry$setLeashedTo(target, true);
                attachedAny = true;
            }
            if (attachedAny) {
                target.f_19853_.m_220407_(GameEvent.f_223708_, target.m_20183_(), GameEvent.Context.m_223717_((Entity)player));
                target.m_5496_(SoundEvents.f_12087_, 1.0f, 1.0f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
        if (stack.m_204117_(Tags.Items.SHEARS) && LeashEvents.shearOffAllLeashConnections(target, player)) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(event.getHand()));
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (target.m_6084_() && target instanceof Leashable) {
            leashable = (Leashable)target;
            if (leashable.raspberry$getLeashHolder() == player) {
                if (!target.f_19853_.f_46443_) {
                    leashable.raspberry$dropLeash(true, !player.m_7500_());
                    target.f_19853_.m_214171_(GameEvent.f_223708_, target.m_20182_(), GameEvent.Context.m_223717_((Entity)player));
                    target.m_5496_(SoundEvents.f_12033_, 1.0f, 1.0f);
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
            if (stack.m_150930_(Items.f_42655_) && !(leashable.raspberry$getLeashHolder() instanceof Player)) {
                if (target instanceof LeashFenceKnotEntity) {
                    return;
                }
                if (!target.f_19853_.f_46443_ && leashable.canHaveALeashAttachedTo((Entity)player)) {
                    if (leashable.raspberry$isLeashed()) {
                        leashable.raspberry$dropLeash(true, true);
                    }
                    leashable.raspberry$setLeashedTo((Entity)player, true);
                    target.m_5496_(SoundEvents.f_12087_, 1.0f, 1.0f);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        Entity target = event.getTarget();
        if (target instanceof LeashFenceKnotEntity) {
            KnotConnectionAccess access;
            KnotConnectionManager manager;
            LeashFenceKnotEntity knot = (LeashFenceKnotEntity)target;
            if (target instanceof KnotConnectionAccess && (manager = (access = (KnotConnectionAccess)target).raspberry$getConnectionManager()).hasConnections()) {
                KnotConnectionSyncPacket packet = new KnotConnectionSyncPacket(knot.m_19879_(), manager.getConnectedUuids());
                packet.sendTo((ServerPlayer)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        BlockState state = event.getState();
        if (!state.m_204336_(BlockTags.f_13039_)) {
            return;
        }
        Level level = (Level)event.getLevel();
        if (level.f_46443_) {
            return;
        }
        BlockPos pos = event.getPos();
        List knots = level.m_6443_(LeashFenceKnotEntity.class, new AABB(pos), knot -> knot.m_31748_().equals((Object)pos));
        for (LeashFenceKnotEntity knot2 : knots) {
            if (knot2 instanceof KnotConnectionAccess) {
                KnotInteractionHelper.discardCustomConnections(knot2, (Entity)event.getPlayer());
            }
            knot2.m_146870_();
        }
    }

    public static boolean shearOffAllLeashConnections(Entity entity, Player player) {
        Level level;
        boolean sheared = LeashEvents.dropAllLeashConnections(entity, player);
        if (sheared && (level = entity.f_19853_) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_5594_(null, entity.m_20183_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return sheared;
    }

    public static boolean dropAllLeashConnections(Entity entity, @Nullable Player player) {
        Object leashable;
        boolean dropConnections;
        List<Leashable> leashed = Leashable.leashableLeashedTo(entity);
        boolean bl = dropConnections = !leashed.isEmpty();
        if (entity instanceof Leashable && (leashable = (Leashable)entity).raspberry$isLeashed()) {
            leashable.raspberry$dropLeash(true, true);
            dropConnections = true;
        }
        for (Leashable leashable2 : leashed) {
            leashable2.raspberry$dropLeash(true, true);
        }
        if (entity instanceof LeashFenceKnotEntity) {
            LeashFenceKnotEntity knot = (LeashFenceKnotEntity)entity;
            if (entity instanceof KnotConnectionAccess) {
                KnotInteractionHelper.discardCustomConnections(knot, (Entity)player);
                dropConnections = true;
            }
        }
        if (dropConnections) {
            entity.m_146852_(GameEvent.f_157781_, (Entity)player);
            if (entity instanceof LeashFenceKnotEntity) {
                entity.m_146870_();
            }
            return true;
        }
        return false;
    }
}

