/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.vanillabackport.leash;

import cc.cassian.raspberry.compat.vanillabackport.leash.KnotConnectionAccess;
import cc.cassian.raspberry.compat.vanillabackport.leash.LeashState;
import cc.cassian.raspberry.compat.vanillabackport.leash.Leashable;
import cc.cassian.raspberry.mixin.minecraft.EntityRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LeashRenderer<T extends Entity> {
    private static final float LEASH_THICKNESS = 0.075f;
    private final EntityRenderDispatcher dispatcher;
    @Nullable
    private List<LeashState> leashStates;

    public LeashRenderer(EntityRenderDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public boolean shouldRender(T entity, Frustum camera, boolean isVisible) {
        if (!isVisible) {
            AABB holderBox;
            Leashable leashable;
            Entity holder;
            AABB entityBox = entity.m_6921_().m_82400_(0.5);
            if (Double.isNaN(entityBox.f_82288_) || entityBox.m_82309_() == 0.0) {
                entityBox = new AABB(entity.m_20185_() - 2.0, entity.m_20186_() - 2.0, entity.m_20189_() - 2.0, entity.m_20185_() + 2.0, entity.m_20186_() + 2.0, entity.m_20189_() + 2.0);
            }
            if (camera.m_113029_(entityBox)) {
                return true;
            }
            if (entity instanceof Leashable && (holder = (leashable = (Leashable)entity).raspberry$getLeashHolder()) != null && (camera.m_113029_(holderBox = holder.m_6921_()) || camera.m_113029_(entityBox.m_82367_(holderBox)))) {
                return true;
            }
            if (entity instanceof KnotConnectionAccess) {
                KnotConnectionAccess access = (KnotConnectionAccess)entity;
                List<LeashFenceKnotEntity> connectedKnots = access.raspberry$getConnectionManager().getConnectedKnots((LeashFenceKnotEntity)entity);
                for (LeashFenceKnotEntity knot : connectedKnots) {
                    AABB knotBox = knot.m_6921_();
                    if (!camera.m_113029_(knotBox) && !camera.m_113029_(entityBox.m_82367_(knotBox))) continue;
                    return true;
                }
            }
        }
        return isVisible;
    }

    public void render(T entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer) {
        this.setupLeashRendering(entity, partialTick);
        if (this.leashStates != null) {
            for (LeashState state : this.leashStates) {
                this.renderLeash(poseStack, buffer, state);
            }
        }
    }

    private void renderLeash(PoseStack stack, MultiBufferSource buffer, LeashState state) {
        int segment;
        float deltaX = (float)(state.end.f_82479_ - state.start.f_82479_);
        float deltaY = (float)(state.end.f_82480_ - state.start.f_82480_);
        float deltaZ = (float)(state.end.f_82481_ - state.start.f_82481_);
        if (state.isKnotToKnot && deltaY == 0.0f) {
            float horizontalDistance = (float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            float maxDroop = 0.15f;
            float distanceScale = 0.05f;
            state.droopAmount = maxDroop / (1.0f + horizontalDistance * distanceScale);
        }
        float scaleFactor = 1.0f / Mth.m_14116_((float)(deltaX * deltaX + deltaZ * deltaZ)) * 0.05f / 2.0f;
        float offsetZ = deltaZ * scaleFactor;
        float offsetX = deltaX * scaleFactor;
        stack.m_85836_();
        stack.m_85837_(state.offset.f_82479_, state.offset.f_82480_, state.offset.f_82481_);
        VertexConsumer vertices = buffer.m_6299_(RenderType.m_110475_());
        Matrix4f matrices = stack.m_85850_().m_85861_();
        for (segment = 0; segment <= 24; ++segment) {
            LeashRenderer.addVertexPair(vertices, matrices, deltaX, deltaY, deltaZ, 0.075f, offsetZ, offsetX, segment, false, state);
        }
        for (segment = 24; segment >= 0; --segment) {
            LeashRenderer.addVertexPair(vertices, matrices, deltaX, deltaY, deltaZ, 0.0f, offsetZ, offsetX, segment, true, state);
        }
        stack.m_85849_();
    }

    private static void addVertexPair(VertexConsumer vertices, Matrix4f matrices, float deltaX, float deltaY, float deltaZ, float thickness2, float offsetZ, float offsetX, int segment, boolean isInnerFace, LeashState state) {
        float progress = (float)segment / 24.0f;
        int blockLight = (int)Mth.m_14179_((float)progress, (float)state.startBlockLight, (float)state.endBlockLight);
        int skyLight = (int)Mth.m_14179_((float)progress, (float)state.startSkyLight, (float)state.endSkyLight);
        int packedLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        boolean useSecondary = segment % 2 == (isInnerFace ? 1 : 0);
        float A_R = 0.4392157f;
        float A_G = 0.29411766f;
        float A_B = 0.16470589f;
        float B_R = 0.30980393f;
        float B_G = 0.1882353f;
        float B_B = 0.101960786f;
        float red = useSecondary ? 0.30980393f : 0.4392157f;
        float green = useSecondary ? 0.1882353f : 0.29411766f;
        float blue = useSecondary ? 0.101960786f : 0.16470589f;
        float posX = deltaX * progress;
        float posZ = deltaZ * progress;
        float posY = state.slack ? (deltaY > 0.0f ? deltaY * progress * progress : deltaY - deltaY * (1.0f - progress) * (1.0f - progress)) : deltaY * progress;
        if (state.isKnotToKnot && state.droopAmount > 0.0f) {
            float droopFactor = progress * (1.0f - progress) * 4.0f;
            posY -= state.droopAmount * droopFactor;
        }
        vertices.m_85982_(matrices, posX - offsetZ, posY + thickness2, posZ + offsetX).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
        vertices.m_85982_(matrices, posX + offsetZ, posY + 0.075f - thickness2, posZ - offsetX).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
    }

    private void setupLeashRendering(T entity, float partialTicks) {
        Leashable leashable;
        Entity leashHolder;
        ArrayList<LeashState> collector = new ArrayList<LeashState>();
        if (entity instanceof Leashable && (leashHolder = (leashable = (Leashable)entity).raspberry$getLeashHolder()) != null) {
            this.addLeashStates(entity, leashable, leashHolder, partialTicks, collector, false);
        }
        if (entity instanceof KnotConnectionAccess) {
            KnotConnectionAccess access = (KnotConnectionAccess)entity;
            if (entity instanceof Leashable) {
                Leashable leashableSelf = (Leashable)entity;
                List<LeashFenceKnotEntity> connectedKnots = access.raspberry$getConnectionManager().getConnectedKnots((LeashFenceKnotEntity)entity);
                for (LeashFenceKnotEntity targetKnot : connectedKnots) {
                    if (entity.m_20148_().compareTo(targetKnot.m_20148_()) >= 0) continue;
                    this.addLeashStates(entity, leashableSelf, (Entity)targetKnot, partialTicks, collector, true);
                }
            }
        }
        this.leashStates = collector.isEmpty() ? null : collector;
    }

    private void addLeashStates(T entity, Leashable leashable, Entity target, float partialTicks, List<LeashState> collector, boolean isKnotToKnot) {
        float entityRotation = Mth.m_14179_((float)partialTicks, (float)((Entity)entity).f_19859_, (float)entity.m_146908_()) * ((float)Math.PI / 180);
        Vec3 leashOffset = leashable.raspberry$getLeashOffset(partialTicks);
        BlockPos entityPos = new BlockPos(entity.m_20299_(partialTicks));
        BlockPos holderPos = new BlockPos(target.m_20299_(partialTicks));
        int entityBlockLight = this.getBlockLightLevel((Entity)entity, entityPos);
        int holderBlockLight = this.getBlockLightLevel(target, holderPos);
        int entitySkyLight = ((Entity)entity).f_19853_.m_45517_(LightLayer.SKY, entityPos);
        int holderSkyLight = ((Entity)entity).f_19853_.m_45517_(LightLayer.SKY, holderPos);
        Vec3 rotatedOffset = leashOffset.m_82524_(-entityRotation);
        LeashState leashState = new LeashState();
        leashState.offset = rotatedOffset;
        leashState.start = entity.m_20318_(partialTicks).m_82549_(rotatedOffset);
        if (isKnotToKnot && target instanceof Leashable) {
            Leashable targetLeashable = (Leashable)target;
            float targetRotation = Mth.m_14179_((float)partialTicks, (float)target.f_19859_, (float)target.m_146908_()) * ((float)Math.PI / 180);
            Vec3 targetOffset = targetLeashable.raspberry$getLeashOffset(partialTicks).m_82524_(-targetRotation);
            leashState.end = target.m_20318_(partialTicks).m_82549_(targetOffset);
        } else {
            leashState.end = target.m_7398_(partialTicks);
        }
        leashState.startBlockLight = entityBlockLight;
        leashState.endBlockLight = holderBlockLight;
        leashState.startSkyLight = entitySkyLight;
        leashState.endSkyLight = holderSkyLight;
        leashState.slack = isKnotToKnot;
        leashState.isKnotToKnot = isKnotToKnot;
        collector.add(leashState);
    }

    private int getBlockLightLevel(Entity entity, BlockPos pos) {
        return ((EntityRendererAccessor)this.dispatcher.m_114382_(entity)).callGetBlockLightLevel(entity, pos);
    }
}

