/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.vanillabackport.leash.network;

import cc.cassian.raspberry.compat.vanillabackport.leash.KnotConnectionAccess;
import cc.cassian.raspberry.network.RaspberryNetwork;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class KnotConnectionSyncPacket {
    private final int entityId;
    private final Set<UUID> connectedUuids;

    public KnotConnectionSyncPacket(int entityId, Set<UUID> connectedUuids) {
        this.entityId = entityId;
        this.connectedUuids = new HashSet<UUID>(connectedUuids);
    }

    public KnotConnectionSyncPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        int size = buf.m_130242_();
        this.connectedUuids = new HashSet<UUID>();
        for (int i = 0; i < size; ++i) {
            this.connectedUuids.add(buf.m_130259_());
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130130_(this.connectedUuids.size());
        for (UUID uuid : this.connectedUuids) {
            buf.m_130077_(uuid);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            Entity entity = mc.f_91073_.m_6815_(this.entityId);
            if (entity instanceof LeashFenceKnotEntity && entity instanceof KnotConnectionAccess) {
                KnotConnectionAccess access = (KnotConnectionAccess)entity;
                access.raspberry$getConnectionManager().setConnectedUuids(new HashSet<UUID>(this.connectedUuids));
            }
        });
        context.get().setPacketHandled(true);
    }

    public void sendTo(ServerPlayer player) {
        RaspberryNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)this);
    }
}

