/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.config;

import cc.cassian.raspberry.RaspberryMod;
import cc.cassian.raspberry.config.MusicFrequency;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static ModConfig INSTANCE = new ModConfig();
    public boolean aftershock = true;
    public boolean stovesStartLit = false;
    public boolean campfiresStartLit = false;
    public boolean braziersStartLit = false;
    public boolean hideWorldVersion = true;
    public boolean hideTooltips = true;
    public boolean thrownItemParticles = true;
    public boolean gliders_disableLightning = true;
    public boolean gliders_disableNetherDamage = true;
    public int aquaculture_badBaitLureBonus = 1;
    public int aquaculture_midBaitLureBonus = 2;
    public int aquaculture_goodBaitLureBonus = 3;
    public int aquaculture_wormDiscoveryRange = 80;
    public boolean create_blastproofing = true;
    public boolean searchContainers = true;
    public boolean horses_noWander = true;
    public boolean horses_noBuck = true;
    public boolean horses_stepHeight = true;
    public boolean emi_tablets = true;
    public boolean toms_hideBeacon = true;
    public int mirrorSearchRadius = 24;
    public int mirrorVerticalSearchRadius = 12;
    public int mirrorParticleSearchRadius = 48;
    public int mirrorVerticalParticleSearchRadius = 24;
    public double mirrorVolumeModifier = 0.4;
    public boolean sunSensitiveRaiders = false;
    public boolean mapsWorkInInventory = false;
    public boolean create_emi = false;
    public boolean better_haste = true;
    public boolean bannerlessRaiders = false;
    public boolean naturalist_stackableItems = true;
    public double rose_gold_bomb_knockback = 1.5;
    public int rose_gold_arrow_knockback = 2;
    public double rose_gold_arrow_velocity = 1.5;
    public boolean unified_wrenches = false;
    public boolean saferKnightJump = true;
    public boolean raspberryCartEngine = true;
    public double raspberryCartMaxSpeed = 34.0;
    public boolean dungeons_mobs_revised_cobwebs = true;
    public boolean ghastDragonFireball = false;
    public boolean backportLeash = true;
    public boolean disableBirchLeafTinting = true;
    public boolean jadeRequiresScoping = true;
    public MusicFrequency musicFrequency = MusicFrequency.DEFAULT;
    public boolean showMusicToast = false;
    public boolean disableFaucetSourceBlocks = false;

    public static void load() {
        if (!Files.exists(ModConfig.configPath(), new LinkOption[0])) {
            ModConfig.save();
            return;
        }
        try (InputStream input = Files.newInputStream(ModConfig.configPath(), new OpenOption[0]);){
            INSTANCE = (ModConfig)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), ModConfig.class);
        }
        catch (IOException e) {
            RaspberryMod.LOGGER.warn("Unable to load config file!");
        }
    }

    public static void save() {
        try (OutputStream output = Files.newOutputStream(ModConfig.configPath(), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            RaspberryMod.LOGGER.warn("Unable to save config file!");
        }
    }

    public static ModConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new ModConfig();
        }
        return INSTANCE;
    }

    public static Path configPath() {
        return Path.of(String.valueOf(FMLPaths.CONFIGDIR.get()) + "/raspberry_core.json", new String[0]);
    }
}

