/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.entity;

import cc.cassian.raspberry.RaspberryMod;
import cc.cassian.raspberry.compat.supplementaries.RoseGoldBombExplosion;
import cc.cassian.raspberry.registry.RaspberryEntityTypes;
import cc.cassian.raspberry.registry.RaspberryItems;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RoseGoldBombEntity
extends ImprovedProjectileEntity {
    private final boolean hasFuse = (Integer)CommonConfigs.Tools.BOMB_FUSE.get() != 0;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;

    public RoseGoldBombEntity(EntityType<RoseGoldBombEntity> type, Level world) {
        super(type, world);
        this.maxAge = this.hasFuse ? (Integer)CommonConfigs.Tools.BOMB_FUSE.get() : 200;
    }

    public RoseGoldBombEntity(Level worldIn, LivingEntity throwerIn) {
        super((EntityType)RaspberryEntityTypes.ROSE_GOLD_BOMB.get(), throwerIn, worldIn);
        this.maxAge = this.hasFuse ? (Integer)CommonConfigs.Tools.BOMB_FUSE.get() : 200;
    }

    public RoseGoldBombEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)RaspberryEntityTypes.ROSE_GOLD_BOMB.get(), x, y, z, worldIn);
        this.maxAge = this.hasFuse ? (Integer)CommonConfigs.Tools.BOMB_FUSE.get() : 200;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Active", this.active);
        compound.m_128405_("Timer", this.changeTimer);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.active = compound.m_128471_("Active");
        this.changeTimer = compound.m_128451_("Timer");
    }

    public Packet<?> m_5654_() {
        return PlatformHelper.getEntitySpawnPacket((Entity)this);
    }

    protected Item m_7881_() {
        return RaspberryItems.ROSE_GOLD_BOMB.get();
    }

    public ItemStack m_7846_() {
        return RaspberryItems.ROSE_GOLD_BOMB.get().m_7968_();
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModRegistry.BOMB_ITEM.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void m_7822_(byte id) {
        switch (id) {
            default: {
                super.m_7822_(id);
                break;
            }
            case 3: {
                this.spawnBreakParticles();
                this.m_146870_();
                break;
            }
            case 10: {
                this.spawnBreakParticles();
                if (MiscUtils.FESTIVITY.isBirthday()) {
                    this.spawnParticleInASphere((ParticleOptions)ModParticles.CONFETTI_PARTICLE.get(), 55, 0.3f);
                } else {
                    this.f_19853_.m_7106_((ParticleOptions)ModParticles.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), BombEntity.BombType.NORMAL.getRadius(), 0.0, 0.0);
                }
                this.spawnParticleInASphere((ParticleOptions)ParticleTypes.f_123797_, 100, 5.0f);
                this.m_146870_();
                break;
            }
            case 68: {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 67: {
                RandomSource random = this.f_19853_.m_213780_();
                for (int i = 0; i < 10; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + 0.25 - (double)(random.m_188501_() * 0.5f), this.m_20186_() + (double)0.45f - (double)(random.m_188501_() * 0.5f), this.m_20189_() + 0.25 - (double)(random.m_188501_() * 0.5f), 0.0, 0.005, 0.0);
                }
                this.active = false;
            }
        }
    }

    private void spawnParticleInASphere(ParticleOptions type, int amount, float speed) {
        double d = Math.PI * 2 / (double)amount;
        float d22 = 0.0f;
        while ((double)d22 < Math.PI * 2) {
            Vec3 v = new Vec3((double)speed, 0.0, 0.0);
            v = v.m_82524_(d22 + this.f_19796_.m_188501_() * 0.3f);
            v = v.m_82535_((float)((double)this.f_19796_.m_188501_() * Math.PI));
            this.f_19853_.m_7106_(type, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), v.f_82479_, v.f_82480_, v.f_82481_);
            d22 = (float)((double)d22 + d);
        }
    }

    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    public void m_8119_() {
        if (this.changeTimer > 0) {
            --this.changeTimer;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 0.0, 0.0, 0.0);
        }
        if (this.active && this.m_20069_()) {
            this.turnOff();
        }
        super.m_8119_();
    }

    public void spawnTrailParticles(Vec3 currentPos, Vec3 newPos) {
        if (this.active && !this.f_19803_) {
            double x = currentPos.f_82479_;
            double y = currentPos.f_82480_;
            double z = currentPos.f_82481_;
            double dx = newPos.f_82479_ - x;
            double dy = newPos.f_82480_ - y;
            double dz = newPos.f_82481_ - z;
            int s = 4;
            for (int i = 0; i < s; ++i) {
                double j = (double)i / (double)s;
                this.f_19853_.m_7106_((ParticleOptions)ModParticles.BOMB_SMOKE_PARTICLE.get(), x + dx * j, 0.5 + y + dy * j, z + dz * j, 0.0, 0.02, 0.0);
            }
        }
    }

    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        hit.m_82443_().m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), 1.0f);
        if (hit.m_82443_() instanceof LargeFireball) {
            this.superCharged = true;
            hit.m_82443_().m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void turnOff() {
        if (!this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)67);
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 1.5f);
        }
        this.active = false;
    }

    public void m_6123_(Player entityIn) {
        if (!this.f_19853_.f_46443_ && !this.active && entityIn.m_150109_().m_36054_(this.m_7846_())) {
            entityIn.m_7938_((Entity)this, 1);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        Vec3 vector3d = hit.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vector3d);
        Vec3 vector3d1 = vector3d.m_82541_().m_82490_((double)this.m_7139_());
        this.m_20343_(this.m_20185_() - vector3d1.f_82479_, this.m_20186_() - vector3d1.f_82480_, this.m_20189_() - vector3d1.f_82481_);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!(this.f_19853_.f_46443_ || this.hasFuse || this.m_213877_())) {
            this.reachedEndOfLife();
        }
    }

    protected void m_37283_() {
    }

    public void reachedEndOfLife() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12198_, SoundSource.NEUTRAL, 1.5f, 1.5f);
        if (!this.f_19853_.f_46443_) {
            if (this.active) {
                this.createExplosion();
                this.f_19853_.m_7605_((Entity)this, (byte)10);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)3);
            }
            this.m_146870_();
        }
    }

    private void createExplosion() {
        try {
            Player p;
            Entity entity;
            boolean breaks;
            boolean bl = breaks = this.m_37282_() instanceof Player || PlatformHelper.isMobGriefingOn((Level)this.f_19853_, (Entity)this.m_37282_());
            if (CompatHandler.FLAN && (entity = this.m_37282_()) instanceof Player && !FlanCompat.canBreak((Player)(p = (Player)entity), (BlockPos)new BlockPos(this.m_20182_()))) {
                breaks = false;
            }
            if (this.superCharged) {
                this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, breaks, breaks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
            }
            RoseGoldBombExplosion explosion = new RoseGoldBombExplosion(this.f_19853_, (Entity)this, new RoseGoldBombExplosion.RoseGoldBombExplosionDamageCalculator(), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 4.0f, BombEntity.BombType.NORMAL, breaks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
            explosion.m_46061_();
            explosion.doFinalizeExplosion();
        }
        catch (Exception e) {
            this.m_146870_();
            RaspberryMod.LOGGER.error("Something went wrong while exploding a bomb:", (Throwable)e);
            throw e;
        }
    }
}

