/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.entity;

import cc.cassian.raspberry.registry.RaspberryEntityTypes;
import cc.cassian.raspberry.registry.RaspberryItems;
import cc.cassian.raspberry.registry.RaspberryParticleTypes;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class SwapArrowEntity
extends AbstractArrow {
    private boolean extraParticles = false;

    public SwapArrowEntity(EntityType<? extends SwapArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SwapArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)RaspberryEntityTypes.SWAP_ARROW.get(), x, y, z, level);
    }

    public SwapArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType)RaspberryEntityTypes.SWAP_ARROW.get(), shooter, level);
    }

    public SwapArrowEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends SwapArrowEntity>)((EntityType)RaspberryEntityTypes.SWAP_ARROW.get()), world);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity target = result.m_82443_();
        Entity shooter = this.m_37282_();
        boolean didTeleport = false;
        if (!this.f_19853_.m_5776_()) {
            BlockPos dispenserPos;
            BlockState blockState;
            if (shooter instanceof LivingEntity && shooter != target) {
                if (target instanceof ArmorStand) {
                    ArmorStand stand = (ArmorStand)target;
                    if (shooter instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)shooter;
                        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
                            ItemStack playerItem = player.m_6844_(slot).m_41777_();
                            ItemStack standItem = stand.m_6844_(slot).m_41777_();
                            player.m_8061_(slot, standItem);
                            stand.m_8061_(slot, playerItem);
                        }
                    }
                }
                if (target instanceof LivingEntity) {
                    Entity targetVehicle = target.m_20202_();
                    Entity shooterVehicle = shooter.m_20202_();
                    if (targetVehicle != null) {
                        target.m_8127_();
                    }
                    if (shooterVehicle != null) {
                        shooter.m_8127_();
                    }
                    Vec3 shooterPos = shooter.m_20182_();
                    Vec3 targetPos = target.m_20182_();
                    target.m_6021_(shooterPos.f_82479_, shooterPos.f_82480_, shooterPos.f_82481_);
                    shooter.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                    if (targetVehicle != null) {
                        shooter.m_7998_(targetVehicle, true);
                    }
                    if (shooterVehicle != null) {
                        target.m_7998_(shooterVehicle, true);
                    }
                    didTeleport = true;
                    this.f_19853_.m_5594_(null, shooter.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.f_19853_.m_5594_(null, target.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (this.getPersistentData().m_128441_("DispenserSourcePosition") && target instanceof LivingEntity && (blockState = this.f_19853_.m_8055_(dispenserPos = BlockPos.m_122022_((long)this.getPersistentData().m_128454_("DispenserSourcePosition")))).m_60734_() instanceof DispenserBlock) {
                BlockEntity dispenserEntity = this.f_19853_.m_7702_(dispenserPos);
                BlockPos targetPos = target.m_20183_();
                if (!this.f_19853_.m_46859_(targetPos) && !this.f_19853_.m_46859_(targetPos = targetPos.m_7494_())) {
                    return;
                }
                this.f_19853_.m_46747_(dispenserPos);
                this.f_19853_.m_7471_(dispenserPos, false);
                Vec3 dispenserVec3 = Vec3.m_82539_((Vec3i)dispenserPos);
                target.m_6021_(dispenserVec3.f_82479_, dispenserVec3.f_82480_, dispenserVec3.f_82481_);
                Direction facing = (Direction)blockState.m_61143_((Property)DispenserBlock.f_52659_);
                this.f_19853_.m_7731_(targetPos, (BlockState)blockState.m_61124_((Property)DispenserBlock.f_52659_, (Comparable)facing.m_122424_()), 3);
                if (dispenserEntity != null) {
                    CompoundTag tag = dispenserEntity.m_187482_();
                    BlockEntity newDispenserEntity = this.f_19853_.m_7702_(targetPos);
                    if (newDispenserEntity != null) {
                        newDispenserEntity.m_142466_(tag);
                        newDispenserEntity.m_6596_();
                    }
                }
                didTeleport = true;
                this.f_19853_.m_5594_(null, dispenserPos, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.f_19853_.m_5594_(null, targetPos, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (didTeleport) {
            this.m_146870_();
        } else {
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.f_19853_.f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    private static Vec3 rotateAroundAxis(Vec3 vec, Vec3 axis, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return vec.m_82490_(cos).m_82549_(axis.m_82537_(vec).m_82490_(sin)).m_82549_(axis.m_82490_(axis.m_82526_(vec) * (1.0 - cos)));
    }

    public void m_8119_() {
        if (this.m_36792_()) {
            this.m_36762_(false);
            this.extraParticles = true;
        }
        super.m_8119_();
        if (this.f_19803_) {
            return;
        }
        if (this.f_36703_) {
            float particleMovement = 0.01f;
            if ((double)this.f_19796_.m_188501_() <= 0.01) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123789_, this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * (double)particleMovement, this.f_19796_.m_188500_() * (double)particleMovement, (this.f_19796_.m_188500_() - 0.5) * (double)particleMovement);
            }
        } else {
            Vec3 vec3 = this.m_20184_();
            double dX = vec3.f_82479_;
            double dY = vec3.f_82480_;
            double dZ = vec3.f_82481_;
            if (this.extraParticles) {
                int particlesPerTick = 8;
                double radius = 0.1;
                double rotationPerTick = Math.toRadians(30.0);
                Vec3 direction = vec3.m_82541_();
                Vec3 perpendicular = direction.m_82537_(new Vec3(0.0, 1.0, 0.0));
                if (perpendicular.m_82556_() < 1.0E-6) {
                    perpendicular = direction.m_82537_(new Vec3(1.0, 0.0, 0.0));
                }
                perpendicular = perpendicular.m_82541_();
                for (int i = 0; i < particlesPerTick; ++i) {
                    if (!((double)this.f_19796_.m_188501_() <= 0.75)) continue;
                    double angle = (double)(this.f_19797_ * particlesPerTick - i) * rotationPerTick;
                    Vec3 rotated = SwapArrowEntity.rotateAroundAxis(perpendicular, direction, angle);
                    Vec3 pos = this.m_20182_();
                    pos = pos.m_82492_(dX * (double)i / (double)particlesPerTick, dY * (double)i / (double)particlesPerTick, dZ * (double)i / (double)particlesPerTick);
                    pos = pos.m_82549_(rotated.m_82490_(radius));
                    this.f_19853_.m_7106_((ParticleOptions)RaspberryParticleTypes.SWAP_ARROW_PORTAL.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, rotated.m_82490_((double)(0.03 * (1.0 - (double)this.f_19796_.m_188501_() * 0.4))).f_82479_, rotated.m_82490_((double)(0.03 * (1.0 - (double)this.f_19796_.m_188501_() * 0.4))).f_82480_, rotated.m_82490_((double)(0.03 * (1.0 - (double)this.f_19796_.m_188501_() * 0.4))).f_82481_);
                }
            } else if ((double)this.f_19796_.m_188501_() <= 0.5) {
                float particleMovement = 0.02f;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123789_, this.m_20185_() - dX, this.m_20186_() - dY, this.m_20189_() - dZ, (this.f_19796_.m_188500_() - 0.5) * (double)particleMovement, (this.f_19796_.m_188500_() - 0.5) * (double)particleMovement, (this.f_19796_.m_188500_() - 0.5) * (double)particleMovement);
            }
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)RaspberryItems.SWAP_ARROW.get());
    }

    public Packet<?> m_5654_() {
        return PlatformHelper.getEntitySpawnPacket((Entity)this);
    }
}

