/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.items;

import cc.cassian.raspberry.registry.RaspberryItems;
import cc.cassian.raspberry.registry.RaspberryTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class CatFoodItem
extends ConsumableItem {
    public static final List<MobEffectInstance> EFFECTS = List.of(new MobEffectInstance(MobEffects.f_19596_, 6000, 0), new MobEffectInstance(MobEffects.f_19600_, 6000, 0), new MobEffectInstance(MobEffects.f_19606_, 6000, 0));

    public CatFoodItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            MutableComponent textWhenFeeding = Component.m_237115_((String)"raspberry.tooltip.cat_food.when_feeding");
            tooltip.add((Component)textWhenFeeding.m_130940_(ChatFormatting.GRAY));
            for (MobEffectInstance effectInstance : EFFECTS) {
                MutableComponent effectDescription = Component.m_237113_((String)" ");
                MutableComponent effectName = Component.m_237115_((String)effectInstance.m_19576_());
                effectDescription.m_7220_((Component)effectName);
                MobEffect effect = effectInstance.m_19544_();
                if (effectInstance.m_19564_() > 0) {
                    effectDescription.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("potion.potency." + effectInstance.m_19564_())));
                }
                if (effectInstance.m_19557_() > 20) {
                    effectDescription.m_130946_(" (").m_130946_(MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f)).m_130946_(")");
                }
                tooltip.add((Component)effectDescription.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Cat cat;
        if (target instanceof Cat && (cat = (Cat)target).m_6084_() && cat.m_21824_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Mod.EventBusSubscriber(modid="raspberry", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CatFoodEvent {
        @SubscribeEvent
        public static void onCatFoodApplied(PlayerInteractEvent.EntityInteract event) {
            Player player = event.getEntity();
            Entity target = event.getTarget();
            ItemStack itemStack = event.getItemStack();
            if (target instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)target;
                if (target.m_6095_().m_204039_(RaspberryTags.CAT_FOOD_USERS)) {
                    boolean isTameable = entity instanceof TamableAnimal;
                    if (entity.m_6084_() && (!isTameable || ((TamableAnimal)entity).m_21824_()) && itemStack.m_41720_().equals(RaspberryItems.CAT_FOOD.get())) {
                        entity.m_21153_(entity.m_21233_());
                        for (MobEffectInstance effect : EFFECTS) {
                            entity.m_7292_(new MobEffectInstance(effect));
                        }
                        entity.f_19853_.m_5594_(null, target.m_20183_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
                        for (int i = 0; i < 5; ++i) {
                            double xSpeed = MathUtils.RAND.nextGaussian() * 0.02;
                            double ySpeed = MathUtils.RAND.nextGaussian() * 0.02;
                            double zSpeed = MathUtils.RAND.nextGaussian() * 0.02;
                            entity.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.STAR.get(), entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), xSpeed, ySpeed, zSpeed);
                        }
                        if (itemStack.getCraftingRemainingItem() != ItemStack.f_41583_ && !player.m_7500_()) {
                            player.m_36356_(itemStack.getCraftingRemainingItem());
                            itemStack.m_41774_(1);
                        }
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

