/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.endermanoverhaul;

import javax.annotation.Nullable;
import net.minecraft.world.entity.monster.EnderMan;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.ReplacedEnderman;

@Mixin(value={ReplacedEnderman.class})
public abstract class ReplacedEndermanMixin {
    @Shadow(remap=false)
    @Nullable
    public abstract EnderMan getEndermanFromState(AnimationEvent<ReplacedEnderman> var1);

    @Overwrite(remap=false)
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)((ReplacedEnderman)this), "controller", 0.0f, state -> {
            EnderMan enderman = this.getEndermanFromState((AnimationEvent<ReplacedEnderman>)state);
            if (enderman == null) {
                return PlayState.STOP;
            }
            if (!state.isMoving()) {
                state.getController().setAnimation(enderman.m_32531_() ? ConstantAnimations.RUN : ConstantAnimations.WALK);
            } else {
                state.getController().setAnimation(ConstantAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)((ReplacedEnderman)this), "creepy_controller", 0.0f, state -> {
            EnderMan enderman = this.getEndermanFromState((AnimationEvent<ReplacedEnderman>)state);
            if (enderman == null) {
                return PlayState.STOP;
            }
            if (!enderman.m_32531_()) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ANGRY);
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)((ReplacedEnderman)this), "hold_controller", 0.0f, state -> {
            EnderMan enderman = this.getEndermanFromState((AnimationEvent<ReplacedEnderman>)state);
            if (enderman == null) {
                return PlayState.STOP;
            }
            if (enderman.m_32530_() == null) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.HOLDING);
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)((ReplacedEnderman)this), "attack_controller", 0.0f, state -> {
            EnderMan enderman = this.getEndermanFromState((AnimationEvent<ReplacedEnderman>)state);
            if (enderman == null) {
                return PlayState.STOP;
            }
            if (enderman.m_21324_(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        }));
    }
}

