/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.compat.vanillabackport.leash.InterpolationHandler;
import cc.cassian.raspberry.compat.vanillabackport.leash.Leashable;
import cc.cassian.raspberry.config.ModConfig;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Boat.class})
public abstract class BoatMixin
extends Entity
implements Leashable {
    @Unique
    private static final EntityDataAccessor<OptionalInt> DATA_ID_LEASH_HOLDER_ID = SynchedEntityData.m_135353_(BoatMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    @Unique
    private int raspberry$delayedLeashHolderId;
    @Unique
    @Nullable
    private Entity raspberry$leashHolder;
    @Unique
    private final InterpolationHandler raspberry$interpolation = new InterpolationHandler(this, 3);
    @Unique
    @Nullable
    private CompoundTag raspberry$leashInfoTag;

    public BoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void raspberry$defineLeashData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_ID_LEASH_HOLDER_ID, (Object)OptionalInt.empty());
    }

    @Unique
    private void raspberry$restoreLeashFromSave() {
        Level level;
        if (this.raspberry$leashInfoTag != null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.raspberry$leashInfoTag.m_128403_("UUID")) {
                UUID uuid = this.raspberry$leashInfoTag.m_128342_("UUID");
                Entity entity = serverLevel.m_8791_(uuid);
                if (entity != null) {
                    this.raspberry$setLeashedTo(entity, true);
                    return;
                }
            } else if (this.raspberry$leashInfoTag.m_128425_("X", 99) && this.raspberry$leashInfoTag.m_128425_("Y", 99) && this.raspberry$leashInfoTag.m_128425_("Z", 99)) {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)this.raspberry$leashInfoTag);
                this.raspberry$setLeashedTo((Entity)LeashFenceKnotEntity.m_31844_((Level)this.f_19853_, (BlockPos)pos), true);
                return;
            }
            if (this.f_19797_ > 100) {
                this.m_19998_((ItemLike)Items.f_42655_);
                this.raspberry$leashInfoTag = null;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void raspberry$tickLeash(CallbackInfo ci) {
        if (!this.f_19853_.f_46443_ && ModConfig.get().backportLeash) {
            if (this.raspberry$leashInfoTag != null) {
                this.raspberry$restoreLeashFromSave();
            }
            if (!(this.raspberry$leashHolder == null || this.m_6084_() && this.raspberry$leashHolder.m_6084_())) {
                this.raspberry$dropLeash(true, true);
            }
            Leashable.tickLeash(this);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void raspberry$saveLeash(CompoundTag compound, CallbackInfo ci) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        if (this.raspberry$leashHolder != null) {
            CompoundTag tag = new CompoundTag();
            if (this.raspberry$leashHolder instanceof LivingEntity) {
                tag.m_128362_("UUID", this.raspberry$leashHolder.m_20148_());
            } else if (this.raspberry$leashHolder instanceof HangingEntity) {
                BlockPos pos = ((HangingEntity)this.raspberry$leashHolder).m_31748_();
                tag.m_128405_("X", pos.m_123341_());
                tag.m_128405_("Y", pos.m_123342_());
                tag.m_128405_("Z", pos.m_123343_());
            }
            compound.m_128365_("Leash", (Tag)tag);
        } else if (this.raspberry$leashInfoTag != null) {
            compound.m_128365_("Leash", (Tag)this.raspberry$leashInfoTag.m_6426_());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void raspberry$readLeash(CompoundTag compound, CallbackInfo ci) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        if (compound.m_128425_("Leash", 10)) {
            this.raspberry$leashInfoTag = compound.m_128469_("Leash");
        }
    }

    @Override
    public boolean raspberry$isLeashed() {
        return ((OptionalInt)this.f_19804_.m_135370_(DATA_ID_LEASH_HOLDER_ID)).isPresent();
    }

    @Override
    @Nullable
    public Entity raspberry$getLeashHolder() {
        if (this.raspberry$leashHolder == null && ((OptionalInt)this.f_19804_.m_135370_(DATA_ID_LEASH_HOLDER_ID)).isPresent() && this.f_19853_.f_46443_) {
            this.raspberry$leashHolder = this.f_19853_.m_6815_(((OptionalInt)this.f_19804_.m_135370_(DATA_ID_LEASH_HOLDER_ID)).getAsInt());
        }
        return this.raspberry$leashHolder;
    }

    @Override
    public void raspberry$setLeashedTo(Entity entity, boolean sendPacket) {
        Level level;
        this.raspberry$leashHolder = entity;
        this.raspberry$leashInfoTag = null;
        this.raspberry$delayedLeashHolderId = 0;
        this.f_19804_.m_135381_(DATA_ID_LEASH_HOLDER_ID, (Object)OptionalInt.of(entity.m_19879_()));
        if (sendPacket && !this.f_19853_.f_46443_ && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, entity));
        }
    }

    @Override
    public void raspberry$dropLeash(boolean broadcast, boolean dropItem) {
        boolean wasLeashed = this.raspberry$leashHolder != null;
        this.raspberry$leashHolder = null;
        this.raspberry$leashInfoTag = null;
        this.raspberry$delayedLeashHolderId = 0;
        this.f_19804_.m_135381_(DATA_ID_LEASH_HOLDER_ID, (Object)OptionalInt.empty());
        if (!this.f_19853_.f_46443_ && wasLeashed) {
            Level level;
            if (dropItem) {
                this.m_19998_((ItemLike)Items.f_42655_);
            }
            if (broadcast && (level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, null));
            }
        }
    }

    @Override
    public void raspberry$setDelayedLeashHolderId(int id) {
        Entity entity;
        this.raspberry$delayedLeashHolderId = id;
        this.raspberry$leashHolder = null;
        this.f_19804_.m_135381_(DATA_ID_LEASH_HOLDER_ID, (Object)OptionalInt.empty());
        if (id != 0 && (entity = this.f_19853_.m_6815_(id)) != null) {
            this.raspberry$setLeashedTo(entity, false);
            this.raspberry$delayedLeashHolderId = 0;
        }
    }

    @Inject(method={"lerpTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void raspberry$lerpTo(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport, CallbackInfo ci) {
        if (ModConfig.get().backportLeash) {
            ci.cancel();
            this.raspberry$interpolation.interpolateTo(new Vec3(x, y, z), yRot, xRot);
        }
    }

    @Inject(method={"tickLerp"}, at={@At(value="HEAD")}, cancellable=true)
    private void raspberry$tickLerp(CallbackInfo ci) {
        if (ModConfig.get().backportLeash) {
            ci.cancel();
            if (this.m_6109_()) {
                this.raspberry$interpolation.cancel();
                this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            }
            this.raspberry$interpolation.interpolate();
        }
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.88f * this.m_20206_()), (double)(0.64f * this.m_20205_()));
    }

    public void m_6089_() {
        super.m_6089_();
        if (ModConfig.get().backportLeash) {
            this.raspberry$dropLeash(true, false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void raspberry$resolveLeash(CallbackInfo ci) {
        Entity entity;
        if (this.f_19853_.f_46443_ && this.raspberry$delayedLeashHolderId != 0 && this.raspberry$getLeashHolder() == null && (entity = this.f_19853_.m_6815_(this.raspberry$delayedLeashHolderId)) != null) {
            this.raspberry$setLeashedTo(entity, false);
            this.raspberry$delayedLeashHolderId = 0;
        }
    }
}

